/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.vineflower.onlyin;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.neoforged.vineflower.onlyin.OnlyInOptions;
import org.jetbrains.java.decompiler.api.java.JavaPassLocation;
import org.jetbrains.java.decompiler.api.java.JavaPassRegistrar;
import org.jetbrains.java.decompiler.api.plugin.Plugin;
import org.jetbrains.java.decompiler.api.plugin.PluginOptions;
import org.jetbrains.java.decompiler.api.plugin.pass.NamedPass;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.ContextUnit;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.util.Pair;

public class OnlyInPlugin
implements Plugin {
    private static final AnnotationExprent ANNOTATION_CLIENT = OnlyInPlugin.makeAnnotation("CLIENT");
    private static final AnnotationExprent ANNOTATION_SERVER = OnlyInPlugin.makeAnnotation("DEDICATED_SERVER");
    private volatile Manifest manifest;

    public String id() {
        return "neoforged-vineflower-onlyin";
    }

    public String description() {
        return "Remove the final modifier from all method parameters.";
    }

    public void registerJavaPasses(JavaPassRegistrar registrar) {
        registrar.register(JavaPassLocation.BEFORE_MAIN, new NamedPass(this.id(), context -> {
            if (!DecompilerContext.getOption((String)"add-onlyin")) {
                return false;
            }
            Manifest manifest = this.getOrLoadManifest();
            StructClass parent = context.getEnclosingClass();
            if (parent.qualifiedName.contains("$")) {
                return true;
            }
            Attributes entryAttr = manifest.getEntries().get(parent.qualifiedName + ".class");
            if (entryAttr == null) {
                return true;
            }
            String entryDist = entryAttr.getValue("Minecraft-Dist");
            if (entryDist != null) {
                AnnotationExprent annotation;
                if ("client".equals(entryDist)) {
                    annotation = ANNOTATION_CLIENT;
                } else if ("server".equals(entryDist)) {
                    annotation = ANNOTATION_SERVER;
                } else {
                    return true;
                }
                StructAnnotationAttribute annotations = (StructAnnotationAttribute)parent.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS);
                if (annotations != null && annotations.getAnnotations().stream().anyMatch(a -> a.getClassName().equals(annotation.getClassName()))) {
                    return true;
                }
                if (annotations == null) {
                    annotations = new StructAnnotationAttribute();
                    parent.getAttributes().put(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS.name, annotations);
                }
                if (annotations.getAnnotations() == null) {
                    annotations.setAnnotations(new ArrayList());
                }
                annotations.getAnnotations().add(annotation);
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getOrLoadManifest() {
        Manifest manifest = this.manifest;
        if (manifest == null) {
            OnlyInPlugin onlyInPlugin = this;
            synchronized (onlyInPlugin) {
                manifest = this.manifest;
                if (manifest == null) {
                    manifest = this.manifest = OnlyInPlugin.loadManifest();
                }
            }
        }
        return manifest;
    }

    public PluginOptions getPluginOptions() {
        return () -> Pair.of(OnlyInOptions.class, OnlyInOptions::addDefaults);
    }

    private static AnnotationExprent makeAnnotation(String dist) {
        return new AnnotationExprent("net/neoforged/api/distmarker/OnlyIn", List.of("value"), List.of(new FieldExprent(dist, "net/neoforged/api/distmarker/Dist", true, null, FieldDescriptor.parseDescriptor((String)"Lnet/neoforged/api/distmarker/Dist;"), null)));
    }

    /*
     * Loose catch block
     */
    private static Manifest loadManifest() {
        block14: {
            InputStream input;
            StructContext structContext = DecompilerContext.getStructContext();
            Field unitsField = structContext.getClass().getDeclaredField("units");
            unitsField.setAccessible(true);
            List units = (List)unitsField.get(structContext);
            for (Object unitObj : units) {
                if (!((ContextUnit)unitObj).isOwn()) continue;
                Field sourceField = unitObj.getClass().getDeclaredField("source");
                sourceField.setAccessible(true);
                IContextSource source = (IContextSource)sourceField.get(unitObj);
                for (IContextSource.Entry other : source.getEntries().others()) {
                    Manifest manifest;
                    block13: {
                        if (!other.path().equals("META-INF/MANIFEST.MF")) continue;
                        DecompilerContext.getLogger().writeMessage("Loading Minecraft-Dist manifest data from " + source.getName(), IFernflowerLogger.Severity.WARN);
                        input = source.getInputStream(other);
                        manifest = new Manifest(input);
                        if (input == null) break block13;
                        input.close();
                    }
                    return manifest;
                }
            }
            break block14;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return new Manifest();
    }
}

