/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.vineflower.unfinal;

import java.util.List;
import net.neoforged.vineflower.unfinal.UnfinalParametersOptions;
import org.jetbrains.java.decompiler.api.java.JavaPassLocation;
import org.jetbrains.java.decompiler.api.java.JavaPassRegistrar;
import org.jetbrains.java.decompiler.api.plugin.Plugin;
import org.jetbrains.java.decompiler.api.plugin.PluginOptions;
import org.jetbrains.java.decompiler.api.plugin.pass.NamedPass;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructMethodParametersAttribute;
import org.jetbrains.java.decompiler.util.Pair;

public class UnfinalParametersPlugin
implements Plugin {
    public String id() {
        return "neoforged-vineflower-unfinal-params";
    }

    public String description() {
        return "Remove the final modifier from all method parameters.";
    }

    public void registerJavaPasses(JavaPassRegistrar registrar) {
        registrar.register(JavaPassLocation.AT_END, new NamedPass(this.id(), context -> {
            if (!DecompilerContext.getOption((String)"unfinal-params")) {
                return false;
            }
            StructMethod method = context.getMethod();
            StructMethodParametersAttribute methodParameters = (StructMethodParametersAttribute)method.getAttribute(StructGeneralAttribute.ATTRIBUTE_METHOD_PARAMETERS);
            if (methodParameters != null) {
                List<StructMethodParametersAttribute.Entry> newEntries = methodParameters.getEntries().stream().map(entry -> new StructMethodParametersAttribute.Entry(entry.myName, entry.myAccessFlags & 0xFFFFFFEF)).toList();
                methodParameters.setEntries(newEntries);
            }
            return true;
        }));
    }

    public PluginOptions getPluginOptions() {
        return () -> Pair.of(UnfinalParametersOptions.class, UnfinalParametersOptions::addDefaults);
    }
}

