/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.vineflower.onlyin;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import net.neoforged.vineflower.onlyin.OnlyInOptions;
import net.neoforged.vineflower.onlyin.OnlyInState;
import org.jetbrains.java.decompiler.api.java.JavaPassLocation;
import org.jetbrains.java.decompiler.api.java.JavaPassRegistrar;
import org.jetbrains.java.decompiler.api.plugin.Plugin;
import org.jetbrains.java.decompiler.api.plugin.PluginOptions;
import org.jetbrains.java.decompiler.api.plugin.pass.NamedPass;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.util.Key;
import org.jetbrains.java.decompiler.util.Pair;

public class OnlyInPlugin
implements Plugin {
    private static final Key<OnlyInState> STATE = Key.of((String)"ONLYIN_STATE");
    private static final AnnotationExprent ANNOTATION_CLIENT = OnlyInPlugin.makeAnnotation("CLIENT");
    private static final AnnotationExprent ANNOTATION_SERVER = OnlyInPlugin.makeAnnotation("DEDICATED_SERVER");

    public String id() {
        return "neoforged-vineflower-onlyin";
    }

    public String description() {
        return "Remove the final modifier from all method parameters.";
    }

    public void registerJavaPasses(JavaPassRegistrar registrar) {
        registrar.register(JavaPassLocation.BEFORE_MAIN, new NamedPass(this.id(), context -> {
            if (!DecompilerContext.getOption((String)"add-onlyin")) {
                return false;
            }
            Class<DecompilerContext> clazz = DecompilerContext.class;
            synchronized (DecompilerContext.class) {
                OnlyInState state = (OnlyInState)DecompilerContext.getContextProperty(STATE);
                if (state == null && (state = (OnlyInState)DecompilerContext.getContextProperty(STATE)) == null) {
                    state = new OnlyInState();
                    DecompilerContext.setProperty(STATE, (Object)state);
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                StructClass parent = context.getEnclosingClass();
                if (parent.qualifiedName.contains("$")) {
                    return true;
                }
                Attributes entryAttr = state.manifest.getEntries().get(parent.qualifiedName + ".class");
                if (entryAttr == null) {
                    return true;
                }
                String entryDist = entryAttr.getValue("Minecraft-Dist");
                if (entryDist != null) {
                    AnnotationExprent annotation;
                    if ("client".equals(entryDist)) {
                        annotation = ANNOTATION_CLIENT;
                    } else if ("server".equals(entryDist)) {
                        annotation = ANNOTATION_SERVER;
                    } else {
                        return true;
                    }
                    StructAnnotationAttribute annotations = (StructAnnotationAttribute)parent.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS);
                    if (annotations != null && annotations.getAnnotations().stream().anyMatch(a -> a.getClassName().equals(annotation.getClassName()))) {
                        return true;
                    }
                    if (annotations == null) {
                        annotations = new StructAnnotationAttribute();
                        parent.getAttributes().put(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS.name, annotations);
                    }
                    if (annotations.getAnnotations() == null) {
                        annotations.setAnnotations(new ArrayList());
                    }
                    annotations.getAnnotations().add(annotation);
                }
                return true;
            }
        }));
    }

    public PluginOptions getPluginOptions() {
        return () -> Pair.of(OnlyInOptions.class, OnlyInOptions::addDefaults);
    }

    private static AnnotationExprent makeAnnotation(String dist) {
        return new AnnotationExprent("net/neoforged/api/distmarker/OnlyIn", List.of("value"), List.of(new FieldExprent(dist, "net/neoforged/api/distmarker/Dist", true, null, FieldDescriptor.parseDescriptor((String)"Lnet/neoforged/api/distmarker/Dist;"), null)));
    }
}

