/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.trainingwheels.gradle.base.task;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class TaskMockingUtils {
    private TaskMockingUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: TaskMockingUtils. This is a utility class");
    }

    public static <T extends Task> T mockTask(Class<T> taskClass, Project project, String name) {
        Task task = (Task)Mockito.mock(taskClass);
        Mockito.when((Object)task.getProject()).thenReturn((Object)project);
        Mockito.when((Object)task.getName()).thenReturn((Object)name);
        List properties = Arrays.stream(taskClass.getMethods()).filter(method -> method.getName().startsWith("get") && method.getParameterCount() == 0).filter(method -> method.getReturnType() == Property.class).collect(Collectors.toList());
        for (Method property : properties) {
            AtomicReference value = new AtomicReference();
            Property mockProperty = (Property)Mockito.mock(Property.class);
            Mockito.when((Object)mockProperty.get()).thenAnswer(invocation -> ((Supplier)value.get()).get());
            ((Property)Mockito.doAnswer(invocation -> {
                value.set(() -> invocation.getArgument(0));
                return null;
            }).when((Object)mockProperty)).set(ArgumentMatchers.any());
            ((Property)Mockito.doAnswer(invocation -> {
                Provider provider = (Provider)invocation.getArgument(0);
                value.set(() -> ((Provider)provider).get());
                return null;
            }).when((Object)mockProperty)).set((Provider)ArgumentMatchers.any());
            try {
                Mockito.when((Object)property.invoke((Object)task, new Object[0])).thenReturn((Object)mockProperty);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Can not mock property!", e);
            }
        }
        List fileProperties = Arrays.stream(taskClass.getMethods()).filter(method -> method.getName().startsWith("get") && method.getParameterCount() == 0).filter(method -> method.getReturnType() == RegularFileProperty.class).collect(Collectors.toList());
        for (Method property : fileProperties) {
            AtomicReference value = new AtomicReference();
            RegularFileProperty mockProperty = (RegularFileProperty)Mockito.mock(RegularFileProperty.class);
            Mockito.when((Object)mockProperty.get()).thenAnswer(invocation -> (RegularFile)((Supplier)value.get()).get());
            ((RegularFileProperty)Mockito.doAnswer(invocation -> {
                RegularFile regularFile = (RegularFile)invocation.getArgument(0);
                value.set(() -> regularFile);
                return null;
            }).when((Object)mockProperty)).set((File)ArgumentMatchers.any());
            ((RegularFileProperty)Mockito.doAnswer(invocation -> {
                File file = (File)invocation.getArgument(0);
                RegularFile regularFile = (RegularFile)Mockito.mock(RegularFile.class);
                Mockito.when((Object)regularFile.getAsFile()).thenReturn((Object)file);
                value.set(() -> regularFile);
                return null;
            }).when((Object)mockProperty)).set((File)ArgumentMatchers.any());
            ((RegularFileProperty)Mockito.doAnswer(invocation -> {
                Provider provider = (Provider)invocation.getArgument(0);
                value.set(() -> ((Provider)provider).get());
                return null;
            }).when((Object)mockProperty)).set((Provider)ArgumentMatchers.any());
            try {
                Mockito.when((Object)property.invoke((Object)task, new Object[0])).thenReturn((Object)mockProperty);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Can not mock property!", e);
            }
        }
        return (T)task;
    }

    public static <T extends Task> TaskProvider<T> mockTaskProvider(T task) {
        TaskProvider taskProvider = (TaskProvider)Mockito.mock(TaskProvider.class);
        Mockito.when((Object)taskProvider.get()).thenReturn(task);
        Mockito.when((Object)taskProvider.getName()).thenAnswer(invocation -> task.getName());
        Mockito.when((Object)taskProvider.getOrNull()).thenReturn(task);
        Mockito.when((Object)taskProvider.getOrElse(ArgumentMatchers.any())).thenReturn(task);
        Mockito.when((Object)taskProvider.map((Transformer)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Transformer transformer = (Transformer)invocation.getArgument(0);
            Task resultTask = (Task)transformer.transform((Object)task);
            return TaskMockingUtils.mockTaskProvider(resultTask);
        });
        Mockito.when((Object)taskProvider.flatMap((Transformer)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Transformer transformer = (Transformer)invocation.getArgument(0);
            return transformer.transform((Object)task);
        });
        ((TaskProvider)Mockito.doAnswer(invocation -> {
            Action action = (Action)invocation.getArgument(0);
            action.execute((Object)taskProvider);
            return null;
        }).when((Object)taskProvider)).configure((Action)ArgumentMatchers.any());
        return taskProvider;
    }
}

