/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary;

import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.Identifier;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.impl.test.AbstractTest;
import net.neoforged.testframework.summary.FileSummaryDumper;
import net.neoforged.testframework.summary.FormattingUtil;
import net.neoforged.testframework.summary.TestSummary;
import net.neoforged.testframework.summary.md.Alignment;
import net.neoforged.testframework.summary.md.Table;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public class GitHubActionsStepSummaryDumper
implements FileSummaryDumper {
    private static final String SOURCE_FILE_ROOTS_PROPERTY = "net.neoforged.testframework.sourceFileRoots";
    private final Function<TestSummary, String> heading;

    public GitHubActionsStepSummaryDumper() {
        this("Test Summary");
    }

    public GitHubActionsStepSummaryDumper(String heading) {
        this((TestSummary summary) -> heading);
    }

    public GitHubActionsStepSummaryDumper(Function<TestSummary, String> heading) {
        this.heading = heading;
    }

    @Override
    public Path outputPath(Identifier frameworkId) {
        return Path.of(System.getenv("GITHUB_STEP_SUMMARY"), new String[0]);
    }

    @Override
    public boolean enabled(TestSummary summary) {
        return summary.isGameTestRun() && System.getenv().containsKey("GITHUB_STEP_SUMMARY");
    }

    @Override
    public void write(TestSummary summary, Logger logger, PrintWriter writer) {
        writer.println("# " + this.heading.apply(summary));
        Map testsByStatus = summary.testInfos().stream().collect(Collectors.groupingBy(test -> test.status().result(), () -> new EnumMap(Test.Result.class), Collectors.toList()));
        List failedTests = testsByStatus.getOrDefault((Object)Test.Result.FAILED, List.of());
        List passedTests = testsByStatus.getOrDefault((Object)Test.Result.PASSED, List.of());
        Table.Builder builder = Table.builder().withAlignments(Alignment.LEFT, Alignment.CENTER, Alignment.LEFT, Alignment.LEFT).addRow("Test Id", "Test Result", "Status message", "Test description");
        if (!failedTests.isEmpty()) {
            for (TestSummary.TestInfo failedTest : failedTests) {
                builder.addRow(failedTest.testId(), this.formatStatus(failedTest.result(), !failedTest.manual() && !failedTest.required()), failedTest.status().message(), GitHubActionsStepSummaryDumper.getDescription(failedTest));
            }
        }
        if (!passedTests.isEmpty()) {
            for (TestSummary.TestInfo passedTest : passedTests) {
                builder.addRow(passedTest.testId(), this.formatStatus(passedTest.status().result(), false), passedTest.status().message(), GitHubActionsStepSummaryDumper.getDescription(passedTest));
            }
        }
        if (!passedTests.isEmpty() && failedTests.isEmpty()) {
            writer.println("All tests passed");
        }
        writer.println();
        writer.println(builder.build());
        if (!failedTests.isEmpty() && System.getProperty(SOURCE_FILE_ROOTS_PROPERTY) != null) {
            List<Path> roots = Arrays.stream(System.getProperty(SOURCE_FILE_ROOTS_PROPERTY).split(",")).map(x$0 -> Path.of(x$0, new String[0])).toList();
            record TestLocation(Path path, Method method, String message, int line) {
            }
            ArrayList<TestLocation> locations = new ArrayList<TestLocation>();
            block11: for (TestSummary.TestInfo testInfo : failedTests) {
                AbstractTest.Dynamic dynamic;
                Method method;
                Test test2 = summary.framework().tests().byId(testInfo.testId()).orElseThrow();
                if (!(test2 instanceof AbstractTest.Dynamic) || (method = (dynamic = (AbstractTest.Dynamic)test2).getMethod()) == null) continue;
                Class<?> declaring = method.getDeclaringClass();
                try {
                    InputStream is = declaring.getClassLoader().getResourceAsStream(declaring.getName().replace(".", "/") + ".class");
                    try {
                        if (is == null) continue;
                        final AtomicReference source = new AtomicReference();
                        final AtomicInteger firstLine = new AtomicInteger(-1);
                        final AtomicInteger lastLine = new AtomicInteger();
                        final String desc = Type.getMethodDescriptor((Method)method);
                        new ClassReader(is).accept(new ClassVisitor(this, 589824){
                            {
                                Objects.requireNonNull(this$0);
                                super(arg0);
                            }

                            public void visitSource(String s, String debug) {
                                source.set(s);
                            }

                            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                                if (source.get() != null && name.equals(method.getName()) && desc.equals(descriptor)) {
                                    return new MethodVisitor(this, 589824){
                                        private int lastFoundLine;
                                        {
                                            Objects.requireNonNull(this$1);
                                            super(arg0);
                                        }

                                        public void visitLineNumber(int line, Label start) {
                                            if (firstLine.get() == -1) {
                                                firstLine.set(line);
                                            }
                                            this.lastFoundLine = line;
                                        }

                                        public void visitEnd() {
                                            lastLine.set(this.lastFoundLine);
                                        }
                                    };
                                }
                                return super.visitMethod(access, name, descriptor, signature, exceptions);
                            }
                        }, 4);
                        if (firstLine.get() == -1) continue;
                        String relativeClassPath = declaring.getPackageName().replace(".", "/") + "/" + (String)source.get();
                        for (Path root : roots) {
                            Path possibleFile = root.resolve(relativeClassPath);
                            if (!Files.exists(possibleFile, new LinkOption[0])) continue;
                            int line = firstLine.get();
                            Exception exception = testInfo.status().exception();
                            if (exception != null) {
                                for (StackTraceElement element : exception.getStackTrace()) {
                                    if (!Objects.equals(element.getFileName(), source.get()) || firstLine.get() > element.getLineNumber() || element.getLineNumber() > lastLine.get()) continue;
                                    line = element.getLineNumber();
                                    break;
                                }
                            }
                            locations.add(new TestLocation(possibleFile.toAbsolutePath(), method, testInfo.message(), line));
                            continue block11;
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("Failed to read class declaring method {}", (Object)method, (Object)ex);
                }
            }
            if (!locations.isEmpty()) {
                Path workspace = Path.of(System.getenv("GITHUB_WORKSPACE"), new String[0]).toAbsolutePath();
                String errorMessage = locations.stream().map(loc -> "::error file=" + String.valueOf(workspace.relativize(loc.path())) + ",line=" + loc.line() + ",title=Test " + String.valueOf(loc.method()) + " failed::" + loc.message()).collect(Collectors.joining("\n"));
                System.out.println();
                System.out.println(errorMessage);
                System.out.println();
            }
        }
    }

    protected String formatStatus(Test.Result result, boolean optional) {
        if (result.failed() && !optional) {
            return "\u274c";
        }
        if (result.passed()) {
            return "\u2705";
        }
        return "\u26a0\ufe0f";
    }

    private static String getDescription(TestSummary.TestInfo failedTest) {
        return failedTest.description().stream().filter(c -> !c.getString().equals("GameTest-only")).map(FormattingUtil::componentToPlainString).collect(Collectors.joining("<br/>"));
    }
}

