/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.client;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.client.CommitBasedList;
import net.neoforged.testframework.impl.MutableTestFramework;

public final class TestsOverlay
implements GuiLayer {
    public static final int MAX_DISPLAYED = 5;
    public static final Identifier BG_TEXTURE = Identifier.fromNamespaceAndPath((String)"testframework", (String)"background");
    private final MutableTestFramework impl;
    private final BooleanSupplier enabled;
    private final Object2FloatMap<Test> fading = new Object2FloatOpenHashMap();
    private final List<Test> lastRenderedTests = new ArrayList<Test>(5);
    static final Map<Test.Result, Identifier> ICON_BY_RESULT = new EnumMap<Test.Result, Identifier>(Map.of(Test.Result.FAILED, Identifier.fromNamespaceAndPath((String)"testframework", (String)"test_failed"), Test.Result.PASSED, Identifier.fromNamespaceAndPath((String)"testframework", (String)"test_passed"), Test.Result.NOT_PROCESSED, Identifier.fromNamespaceAndPath((String)"testframework", (String)"test_not_processed")));

    public TestsOverlay(MutableTestFramework impl, BooleanSupplier enabled) {
        this.impl = impl;
        this.enabled = enabled;
        this.fading.defaultReturnValue(1.0f);
    }

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (!this.enabled.getAsBoolean()) {
            return;
        }
        List enabled = this.impl.tests().enabled().collect(Collectors.toCollection(ArrayList::new));
        if (enabled.isEmpty()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int startX = 10;
        int startY = 10;
        int maxWidth = graphics.guiWidth() / 3;
        int x = 10;
        int y = 10;
        int maxX = x;
        CommitBasedList renderingQueue = new CommitBasedList(new ArrayList());
        MutableComponent title = Component.literal((String)"Tests overlay for ").append((Component)Component.literal((String)this.impl.id().toString()).withStyle(ChatFormatting.AQUA));
        renderingQueue.addDirectly(this.withXY(x, y, (arg_0, arg_1) -> TestsOverlay.lambda$render$0(graphics, font, (Component)title, arg_0, arg_1)));
        Objects.requireNonNull(font);
        y += 9 + 5;
        maxX += font.width((FormattedText)title);
        if (enabled.size() > 5) {
            int nullIndex;
            List actuallyToRender;
            Map lastCompleted = this.lastRenderedTests.stream().filter(it -> this.impl.tests().getStatus(it.id()).result() == Test.Result.PASSED).collect(Collectors.toMap(Function.identity(), this.lastRenderedTests::indexOf));
            ArrayList finalActuallyToRender = actuallyToRender = new ArrayList(5);
            for (int i = 0; i < 5; ++i) {
                actuallyToRender.add(null);
            }
            lastCompleted.forEach((test, index) -> finalActuallyToRender.set((int)index, test));
            enabled.stream().filter(it -> this.impl.tests().getStatus(it.id()).result() != Test.Result.PASSED).limit(5 - lastCompleted.size()).forEach(it -> finalActuallyToRender.set(finalActuallyToRender.indexOf(null), it));
            while ((nullIndex = actuallyToRender.indexOf(null)) >= 0) {
                actuallyToRender.remove(nullIndex);
            }
            for (Test test2 : List.copyOf(actuallyToRender)) {
                renderingQueue.push();
                int lastY = y;
                int lastMaxX = maxX;
                if (this.impl.tests().getStatus(test2.id()).result() == Test.Result.PASSED) {
                    float fade = this.fading.computeIfAbsent((Object)test2, it -> 1.0f) - 0.005f;
                    if (fade <= 0.0f) {
                        this.fading.removeFloat((Object)test2);
                        actuallyToRender.remove(test2);
                        continue;
                    }
                    XY xy = this.renderTest(font, test2, graphics, maxWidth, x, y, (int)(fade * 255.0f) << 24 | 0xFFFFFF, renderingQueue.currentProgress());
                    y = xy.y() + 5;
                    maxX = Math.max(maxX, xy.x());
                    this.fading.put((Object)test2, fade);
                } else {
                    XY xy = this.renderTest(font, test2, graphics, maxWidth, x, y, -1, renderingQueue.currentProgress());
                    y = xy.y() + 5;
                    maxX = Math.max(maxX, xy.x());
                }
                if (y >= graphics.guiHeight()) {
                    int endIndex = actuallyToRender.indexOf(test2) + 1;
                    if (y > graphics.guiHeight()) {
                        --endIndex;
                        renderingQueue.revert();
                        y = lastY;
                        maxX = lastMaxX;
                    } else {
                        renderingQueue.popAndCommit();
                    }
                    actuallyToRender = actuallyToRender.subList(0, endIndex);
                    break;
                }
                renderingQueue.popAndCommit();
            }
            this.lastRenderedTests.clear();
            this.lastRenderedTests.addAll(actuallyToRender);
        } else {
            for (Test test3 : enabled) {
                int lastY = y;
                int lastMaxX = maxX;
                renderingQueue.push();
                XY xy = this.renderTest(font, test3, graphics, maxWidth, x, y, -1, renderingQueue.currentProgress());
                y = xy.y() + 5;
                maxX = Math.max(maxX, xy.x());
                if (y >= graphics.guiHeight()) {
                    int endIndex = enabled.indexOf(test3) + 1;
                    if (y > graphics.guiHeight()) {
                        renderingQueue.revert();
                        y = lastY;
                        maxX = lastMaxX;
                        --endIndex;
                    } else {
                        renderingQueue.popAndCommit();
                    }
                    enabled = enabled.subList(0, endIndex);
                    break;
                }
                renderingQueue.popAndCommit();
            }
            this.lastRenderedTests.clear();
            this.lastRenderedTests.addAll(enabled);
        }
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BG_TEXTURE, 6, 6, (maxX += 3) - 10 + 4 + 4, y - 10 + 4, Integer.MAX_VALUE);
        renderingQueue.forEach(Runnable::run);
    }

    private XY renderTest(Font font, Test test, GuiGraphics graphics, int maxWidth, int x, int y, int colour, List<Runnable> rendering) {
        Test.Status status = this.impl.tests().getStatus(test.id());
        FormattedCharSequence bullet = Component.literal((String)"- ").withStyle(ChatFormatting.BLACK).getVisualOrderText();
        rendering.add(this.withXY(x, y, (x$, y$) -> graphics.drawString(font, bullet, x$, y$ - 1, colour)));
        rendering.add(this.withXY(x += font.width(bullet) + 1, y, (x$, y$) -> graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ICON_BY_RESULT.get((Object)status.result()), x$, y$, 9, 9)));
        MutableComponent title = TestsOverlay.statusColoured(test.visuals().title(), status);
        rendering.add(this.withXY(x += 11, y, (arg_0, arg_1) -> TestsOverlay.lambda$renderTest$2(graphics, font, (Component)title, colour, arg_0, arg_1)));
        ArrayList<Object> extras = new ArrayList<Object>();
        if (Minecraft.getInstance().hasShiftDown()) {
            extras.addAll(test.visuals().description());
        }
        if (status.result() != Test.Result.PASSED && !status.message().isBlank()) {
            extras.add(Component.literal((String)("!!! " + status.message())).withStyle(ChatFormatting.RED));
        }
        int maxX = x;
        Objects.requireNonNull(font);
        y += 9 + 2;
        if (!extras.isEmpty()) {
            x += 6;
            Iterator charSequences = extras.stream().flatMap(it -> font.split((FormattedText)it, maxWidth).stream()).iterator();
            while (charSequences.hasNext()) {
                FormattedCharSequence extra = (FormattedCharSequence)charSequences.next();
                rendering.add(this.withXY(x, y, (x$, y$) -> graphics.drawString(font, extra, x$, y$, -1)));
                Objects.requireNonNull(font);
                y += 9;
                maxX = Math.max(maxX, x + font.width(extra));
            }
        }
        return new XY(maxX, y);
    }

    private Runnable withXY(int x, int y, IntBiConsumer consumer) {
        return () -> consumer.accept(x, y);
    }

    static MutableComponent statusColoured(Component input, Test.Status status) {
        return switch (status.result()) {
            default -> throw new MatchException(null, null);
            case Test.Result.PASSED -> input.copy().withStyle(ChatFormatting.GREEN);
            case Test.Result.FAILED -> input.copy().withStyle(ChatFormatting.RED);
            case Test.Result.NOT_PROCESSED -> input.copy();
        };
    }

    private static /* synthetic */ void lambda$renderTest$2(GuiGraphics graphics, Font font, Component title, int colour, int x$, int y$) {
        graphics.drawString(font, title, x$, y$, colour);
    }

    private static /* synthetic */ void lambda$render$0(GuiGraphics graphics, Font font, Component title, int x$, int y$) {
        graphics.drawString(font, title, x$, y$, -1);
    }

    @FunctionalInterface
    public static interface IntBiConsumer {
        public void accept(int var1, int var2);
    }

    private record XY(int x, int y) {
    }
}

