/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.client;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.client.TestScreen;
import net.neoforged.testframework.client.TestsOverlay;
import net.neoforged.testframework.group.Group;
import net.neoforged.testframework.impl.MutableTestFramework;

public abstract class AbstractTestScreen
extends Screen {
    protected final MutableTestFramework framework;
    private final Screen outer = this;

    public AbstractTestScreen(Component title, MutableTestFramework framework) {
        super(title);
        this.framework = framework;
    }

    protected final class GroupableList
    extends ObjectSelectionList<Entry> {
        private final Function<String, List<? extends Entry>> entryGetter;
        final /* synthetic */ AbstractTestScreen this$0;

        public GroupableList(AbstractTestScreen this$0, Function<String, List<? extends Entry>> entryGetter, Minecraft pMinecraft, int pWidth, int pHeight, int pY, int pItemHeight) {
            AbstractTestScreen abstractTestScreen = this$0;
            Objects.requireNonNull(abstractTestScreen);
            this.this$0 = abstractTestScreen;
            super(pMinecraft, pWidth, pHeight, pY, pItemHeight);
            this.entryGetter = entryGetter;
        }

        public GroupableList(AbstractTestScreen this$0, BooleanSupplier isGrouped, List<Group> groups, Supplier<Stream<Test>> tests, Minecraft pMinecraft, int pWidth, int pHeight, int pY, int pItemHeight) {
            AbstractTestScreen abstractTestScreen = this$0;
            Objects.requireNonNull(abstractTestScreen);
            this.this$0 = abstractTestScreen;
            super(pMinecraft, pWidth, pHeight, pY, pItemHeight);
            this.entryGetter = search -> isGrouped.getAsBoolean() ? groups.stream().filter(it -> it.title().getString().toLowerCase(Locale.ROOT).contains((CharSequence)search)).sorted(Comparator.comparing(gr -> gr.title().getString())).map(x$0 -> new GroupEntry(this, (Group)x$0)).toList() : this.withGroups(((Stream)tests.get()).filter(it -> it.visuals().title().getString().toLowerCase(Locale.ROOT).contains((CharSequence)search)).sorted(Comparator.comparing(test -> test.visuals().title().getString())), groups).toList();
        }

        public void resetRows(String search) {
            this.clearEntries();
            GroupableList groupableList = this;
            this.entryGetter.apply(search).forEach(x$0 -> groupableList.addEntry((AbstractSelectionList.Entry)x$0));
        }

        protected boolean isValidClickButton(MouseButtonInfo buttonInfo) {
            int button = buttonInfo.button();
            return button == 0 || button == 1 || button == 2;
        }

        protected int scrollBarX() {
            return this.width / 2 + 144;
        }

        public int getRowWidth() {
            return 260;
        }

        public void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
            this.renderTooltips(graphics, pMouseX, pMouseY);
        }

        private void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
            Entry entry;
            if (this.isMouseOver(mouseX, mouseY) && (entry = (Entry)this.getEntryAtPosition(mouseX, mouseY)) != null) {
                entry.renderTooltips(graphics, mouseX, mouseY);
            }
        }

        private Stream<? extends Entry> withGroups(Stream<Test> tests, List<Group> groups) {
            Group parent = groups.size() == 1 ? groups.get(0) : null;
            ListMultimap withParent = (ListMultimap)tests.collect(Multimaps.toMultimap(test -> test.groups().size() < 1 ? "ungrouped" : test.groups().get(0), Function.identity(), () -> Multimaps.newListMultimap(new LinkedHashMap(), ArrayList::new)));
            Predicate<String> isUngrouped = it -> it.equals("ungrouped") || parent != null && it.equals(parent.id());
            Comparator stringComparator = Comparator.naturalOrder();
            return withParent.asMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Group, Collection>(this.this$0.framework.tests().getOrCreateGroup((String)entry.getKey()), (Collection)entry.getValue())).sorted((o1, o2) -> {
                if (isUngrouped.test(((Group)o1.getKey()).id())) {
                    return -1;
                }
                if (isUngrouped.test(((Group)o2.getKey()).id())) {
                    return 1;
                }
                return stringComparator.compare(((Group)o1.getKey()).title().getString(), ((Group)o2.getKey()).title().getString());
            }).flatMap(entry -> {
                if (isUngrouped.test(((Group)entry.getKey()).id())) {
                    return ((Collection)entry.getValue()).stream().map(x$0 -> new TestEntry(this, (Test)x$0));
                }
                return Stream.concat(Stream.of(new GroupEntry(this, (Group)entry.getKey(), true)), ((Collection)entry.getValue()).stream().map(x$0 -> new TestEntry(this, (Test)x$0)));
            });
        }

        protected abstract sealed class Entry
        extends ObjectSelectionList.Entry<Entry>
        permits TestEntry, GroupEntry {
            final /* synthetic */ GroupableList this$1;

            protected Entry(GroupableList this$1) {
                GroupableList groupableList = this$1;
                Objects.requireNonNull(groupableList);
                this.this$1 = groupableList;
            }

            public Component getNarration() {
                return Component.empty();
            }

            public abstract boolean isEnabled();

            public boolean canDisable() {
                return this.isEnabled();
            }

            public boolean canEnable() {
                return !this.isEnabled();
            }

            public abstract void enable(boolean var1);

            public abstract void reset();

            public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
                if (event.button() == 0) {
                    this.this$1.setSelected((AbstractSelectionList.Entry)this);
                    return true;
                }
                if (event.button() == 1) {
                    this.enable(!this.isEnabled());
                } else if (event.button() == 2) {
                    this.reset();
                }
                return false;
            }

            protected void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
            }
        }

        protected final class GroupEntry
        extends Entry {
            private final Group group;
            private final Button browseButton;
            private final boolean isTitle;
            final /* synthetic */ GroupableList this$1;

            private GroupEntry(GroupableList this$1, Group group) {
                this(this$1, group, false);
            }

            private GroupEntry(GroupableList this$1, Group group, boolean isTitle) {
                GroupableList groupableList = this$1;
                Objects.requireNonNull(groupableList);
                this.this$1 = groupableList;
                super(this$1);
                this.group = group;
                this.isTitle = isTitle;
                this.browseButton = Button.builder((Component)Component.literal((String)"Browse"), button -> this.openBrowseGUI()).size(50, 12).pos(0, 0).build();
                if (isTitle) {
                    this.browseButton.active = false;
                    this.browseButton.visible = false;
                }
            }

            public void renderContent(GuiGraphics graphics, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                if (this.isTitle) {
                    graphics.drawCenteredString(this.this$1.this$0.font, this.getTitle(), this.getContentXMiddle(), this.getContentY(), -1);
                } else {
                    graphics.drawString(this.this$1.this$0.font, this.getTitle(), this.getX() + 11, this.getContentY(), -1);
                    this.browseButton.setX(this.getX() + this.getWidth() - 53);
                    this.browseButton.setY(this.getY() - 1);
                    this.browseButton.render(graphics, pMouseX, pMouseY, pPartialTick);
                }
            }

            @Override
            protected void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
                if (this.isTitle) {
                    return;
                }
                List<Test> all = this.group.resolveAll();
                int enabledCount = (int)all.stream().filter(it -> this.this$1.this$0.framework.tests().isEnabled(it.id())).count();
                if (enabledCount == all.size()) {
                    graphics.setTooltipForNextFrame(this.this$1.this$0.font, (Component)Component.literal((String)("All tests in group (" + all.size() + ") are enabled!")).withStyle(ChatFormatting.GREEN), mouseX, mouseY);
                } else if (enabledCount == 0) {
                    graphics.setTooltipForNextFrame(this.this$1.this$0.font, (Component)Component.literal((String)("All tests in group (" + all.size() + ") are disabled!")).withStyle(ChatFormatting.GRAY), mouseX, mouseY);
                } else {
                    graphics.setTooltipForNextFrame(this.this$1.this$0.font, (Component)Component.literal((String)(enabledCount + "/" + all.size() + " tests enabled!")).withStyle(ChatFormatting.BLUE), mouseX, mouseY);
                }
            }

            private Component getTitle() {
                return this.group.title();
            }

            @Override
            public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
                if (this.isTitle) {
                    return false;
                }
                if (this.browseButton.isMouseOver(event.x(), event.y())) {
                    return this.browseButton.mouseClicked(event, doubleClick);
                }
                if (event.button() == 0 && (event.hasShiftDown() || event.hasControlDown())) {
                    this.openBrowseGUI();
                    return false;
                }
                return super.mouseClicked(event, doubleClick);
            }

            private void openBrowseGUI() {
                Minecraft.getInstance().setScreen((Screen)new TestScreen(this, (Component)Component.literal((String)"Tests of group ").append(this.getTitle()), this.this$1.this$0.framework, List.of(this.group)){
                    final /* synthetic */ GroupEntry this$2;
                    {
                        GroupEntry groupEntry = this$2;
                        Objects.requireNonNull(groupEntry);
                        this.this$2 = groupEntry;
                        super(title, framework, groups);
                    }

                    @Override
                    protected void init() {
                        super.init();
                        this.showAsGroup.visible = false;
                        this.showAsGroup.active = false;
                        this.showAsGroup.setValue((Object)false);
                        this.groupableList.resetRows("");
                        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.minecraft.setScreen(this.this$2.this$1.this$0.outer)).size(60, 20).pos(this.width - 20 - 60, this.height - 29).build());
                    }
                });
            }

            @Override
            public boolean isEnabled() {
                return this.group.resolveAll().stream().allMatch(it -> this.this$1.this$0.framework.tests().isEnabled(it.id()));
            }

            @Override
            public boolean canDisable() {
                return this.group.resolveAll().stream().anyMatch(it -> this.this$1.this$0.framework.tests().isEnabled(it.id()));
            }

            @Override
            public boolean canEnable() {
                return this.group.resolveAll().stream().anyMatch(it -> !this.this$1.this$0.framework.tests().isEnabled(it.id()));
            }

            @Override
            public void enable(boolean enable) {
                this.group.resolveAll().forEach(test -> this.this$1.this$0.framework.setEnabled((Test)test, enable, null));
            }

            @Override
            public void reset() {
                this.group.resolveAll().forEach(test -> this.this$1.this$0.framework.changeStatus((Test)test, Test.Status.DEFAULT, null));
            }
        }

        protected final class TestEntry
        extends Entry {
            private final Test test;
            final /* synthetic */ GroupableList this$1;

            private TestEntry(GroupableList this$1, Test test) {
                GroupableList groupableList = this$1;
                Objects.requireNonNull(groupableList);
                this.this$1 = groupableList;
                super(this$1);
                this.test = test;
            }

            public void renderContent(GuiGraphics graphics, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                Test.Status status = this.this$1.this$0.framework.tests().getStatus(this.test.id());
                int alpha = 0x73000000;
                boolean renderTransparent = !this.isEnabled();
                Identifier icon = TestsOverlay.ICON_BY_RESULT.get((Object)status.result());
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, icon, this.getContentX(), this.getContentY(), 9, 9, renderTransparent ? 0x73FFFFFF : -1);
                MutableComponent title = TestsOverlay.statusColoured(this.test.visuals().title(), status);
                graphics.drawString(this.this$1.this$0.font, (Component)title, this.getContentX() + 11, this.getContentY(), renderTransparent ? 0x73FFFFFF : -1);
            }

            @Override
            protected void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
                Test.Status status;
                ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
                if (!this.isEnabled()) {
                    tooltip.add(Component.literal((String)"DISABLED").withStyle(ChatFormatting.GRAY).getVisualOrderText());
                }
                if (!(status = this.this$1.this$0.framework.tests().getStatus(this.test.id())).message().isBlank()) {
                    tooltip.add(Component.literal((String)"!!! ").append(status.message()).withStyle(ChatFormatting.RED).getVisualOrderText());
                }
                for (Component desc : this.test.visuals().description()) {
                    tooltip.addAll(this.this$1.this$0.font.split((FormattedText)desc, 200));
                }
                if (!tooltip.isEmpty()) {
                    graphics.setTooltipForNextFrame(this.this$1.this$0.font, tooltip, mouseX, mouseY);
                }
            }

            @Override
            public boolean isEnabled() {
                return this.this$1.this$0.framework.tests().isEnabled(this.test.id());
            }

            @Override
            public void enable(boolean enable) {
                this.this$1.this$0.framework.setEnabled(this.test, enable, (Entity)((GroupableList)this.this$1).minecraft.player);
            }

            @Override
            public void reset() {
                this.this$1.this$0.framework.changeStatus(this.test, Test.Status.DEFAULT, null);
            }
        }
    }
}

