/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.client;

import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.testframework.client.TestScreen;
import net.neoforged.testframework.client.TestsOverlay;
import net.neoforged.testframework.conf.ClientConfiguration;
import net.neoforged.testframework.impl.FrameworkClient;
import net.neoforged.testframework.impl.MutableTestFramework;

public class FrameworkClientImpl
implements FrameworkClient {
    private final MutableTestFramework impl;
    private final ClientConfiguration configuration;

    public FrameworkClientImpl(MutableTestFramework impl, ClientConfiguration clientConfiguration) {
        this.impl = impl;
        this.configuration = clientConfiguration;
    }

    @Override
    public void init(IEventBus modBus, ModContainer container) {
        BooleanSupplier overlayEnabled;
        KeyMapping.Category keyCategory = new KeyMapping.Category(this.impl.id());
        if (this.configuration.toggleOverlayKey() != 0) {
            ToggleKeyMapping overlayKey = new ToggleKeyMapping("key.testframework.toggleoverlay", this.configuration.toggleOverlayKey(), keyCategory, () -> true, true);
            modBus.addListener(event -> {
                event.register((KeyMapping)overlayKey);
                event.registerCategory(keyCategory);
            });
            overlayEnabled = () -> !overlayKey.isDown();
        } else {
            overlayEnabled = () -> true;
        }
        modBus.addListener(event -> event.registerAboveAll(this.impl.id(), (GuiLayer)new TestsOverlay(this.impl, overlayEnabled)));
        if (this.configuration.openManagerKey() != 0) {
            KeyMapping openManagerKey = new KeyMapping(this, "key.testframework.openmanager", this.configuration.openManagerKey(), keyCategory){
                final /* synthetic */ FrameworkClientImpl this$0;
                {
                    FrameworkClientImpl frameworkClientImpl = this$0;
                    Objects.requireNonNull(frameworkClientImpl);
                    this.this$0 = frameworkClientImpl;
                    super(arg0, arg1, arg2);
                }

                public void setDown(boolean pValue) {
                    if (pValue) {
                        Minecraft.getInstance().setScreen((Screen)new TestScreen((Component)Component.literal((String)"All tests"), this.this$0.impl, List.copyOf(this.this$0.impl.tests().allGroups())));
                    }
                    super.setDown(pValue);
                }
            };
            modBus.addListener(event -> event.register(openManagerKey));
        }
    }

    public static final class Factory
    implements FrameworkClient.Factory {
        @Override
        public FrameworkClient create(MutableTestFramework impl, ClientConfiguration clientConfiguration) {
            return new FrameworkClientImpl(impl, clientConfiguration);
        }
    }
}

