/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import net.neoforged.testframework.gametest.ExtendedSequence;
import net.neoforged.testframework.gametest.GameTestPlayer;
import net.neoforged.testframework.gametest.ParametrizedGameTestSequence;
import org.jetbrains.annotations.Nullable;

public class ExtendedGameTestHelper
extends GameTestHelper {
    public ExtendedGameTestHelper(GameTestInfo info) {
        super(info);
    }

    public ExtendedSequence startSequence() {
        ExtendedSequence sq = new ExtendedSequence(this);
        this.testInfo.sequences.add(sq);
        return sq;
    }

    public void useOn(BlockPos pos, ItemStack item, Player player, Direction direction) {
        player.setItemInHand(InteractionHand.MAIN_HAND, item);
        pos = this.absolutePos(pos);
        item.useOn(new UseOnContext((Level)this.getLevel(), player, InteractionHand.MAIN_HAND, item, new BlockHitResult(pos.getCenter(), direction, pos, false)));
    }

    public void useBlock(BlockPos pos, Player player, ItemStack item) {
        player.setItemInHand(InteractionHand.MAIN_HAND, item);
        this.useBlock(pos, player);
    }

    public void useBlock(BlockPos pos, Player player, ItemStack item, Direction direction) {
        player.setItemInHand(InteractionHand.MAIN_HAND, item);
        BlockPos blockpos = this.absolutePos(pos);
        BlockState blockstate = this.getLevel().getBlockState(blockpos);
        BlockHitResult hit = new BlockHitResult(Vec3.atCenterOf((Vec3i)blockpos), direction, blockpos, true);
        InteractionResult interactionresult = blockstate.useWithoutItem((Level)this.getLevel(), player, hit);
        if (!interactionresult.consumesAction()) {
            UseOnContext useoncontext = new UseOnContext(player, InteractionHand.MAIN_HAND, hit);
            player.getItemInHand(InteractionHand.MAIN_HAND).useOn(useoncontext);
        }
    }

    public <T, E extends Entity> void assertEntityProperty(E entity, Function<E, T> function, String valueName, T expected, BiPredicate<T, T> tester) {
        T value = function.apply(entity);
        if (!tester.test(value, expected)) {
            throw this.assertionException("Entity %s value %s=%s is not equal to expected %s", new Object[]{entity, valueName, value, expected});
        }
    }

    public GameTestPlayer makeTickingMockServerPlayerInCorner(GameType gameType) {
        return this.makeTickingMockServerPlayerInLevel(gameType).moveToCorner();
    }

    public GameTestPlayer makeTickingMockServerPlayerInLevel(GameType gameType) {
        CommonListenerCookie commonlistenercookie = CommonListenerCookie.createInitial((GameProfile)new GameProfile(UUID.randomUUID(), "test-mock-player"), (boolean)false);
        final GameTestPlayer serverplayer = new GameTestPlayer(this.getLevel().getServer(), this.getLevel(), commonlistenercookie.gameProfile(), commonlistenercookie.clientInformation(), this);
        Connection connection = new Connection(this, PacketFlow.SERVERBOUND){

            public void tick() {
                super.tick();
                serverplayer.resetLastActionTime();
            }

            public boolean isMemoryConnection() {
                return true;
            }
        };
        EmbeddedChannel embeddedchannel = new EmbeddedChannel(new ChannelHandler[]{connection});
        NetworkRegistry.configureMockConnection((Connection)connection);
        this.getLevel().getServer().getPlayerList().placeNewPlayer(connection, (ServerPlayer)serverplayer, commonlistenercookie);
        this.getLevel().getServer().getConnection().getConnections().add(connection);
        connection.setupInboundProtocol(connection.getInboundProtocol(), (PacketListener)new ServerGamePacketListenerImpl(this, serverplayer.getServer(), connection, serverplayer, commonlistenercookie){

            protected void keepConnectionAlive() {
            }
        });
        this.testInfo.addListener((GameTestListener)serverplayer);
        serverplayer.gameMode.changeGameModeForPlayer(gameType);
        serverplayer.setYRot(180.0f);
        serverplayer.connection.chunkSender.sendNextChunks((ServerPlayer)serverplayer);
        serverplayer.connection.chunkSender.onChunkBatchReceivedByClient(64.0f);
        serverplayer.setClientLoaded(true);
        return serverplayer;
    }

    public ServerPlayer makeOpMockPlayer(final int commandLevel) {
        return new FakePlayer(this, this.getLevel(), new GameProfile(UUID.randomUUID(), "test-mock-player")){

            public boolean isSpectator() {
                return false;
            }

            public boolean isCreative() {
                return true;
            }

            public boolean isLocalPlayer() {
                return true;
            }

            public int getPermissionLevel() {
                return commandLevel;
            }
        };
    }

    public Stream<BlockPos> blocksBetween(int x, int y, int z, int length, int height, int width) {
        AABB bounds = AABB.encapsulatingFullBlocks((BlockPos)this.absolutePos(new BlockPos(x, y, z)), (BlockPos)this.absolutePos(new BlockPos(x + length, y + height, z + width)));
        return BlockPos.MutableBlockPos.betweenClosedStream((AABB)bounds);
    }

    public <T extends BlockEntity> T getBlockEntity(int x, int y, int z, Class<T> type) {
        return (T)this.getBlockEntity(new BlockPos(x, y, z), type);
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> cap, BlockPos pos, C context) {
        return (T)this.getLevel().getCapability(cap, this.absolutePos(pos), context);
    }

    public <T, C> T requireCapability(BlockCapability<T, C> cap, BlockPos pos, C context) {
        T capability = this.getCapability(cap, pos, context);
        if (capability == null) {
            throw this.assertionException(pos, "Expected capability %s but there was none", new Object[]{cap});
        }
        return capability;
    }

    public <T> ParametrizedGameTestSequence<T> startSequence(Supplier<T> value) {
        return new ParametrizedGameTestSequence<T>(this, this.startSequence(), value);
    }

    public Player makeMockPlayer() {
        return this.makeMockPlayer(GameType.CREATIVE);
    }

    @SafeVarargs
    public final void killAllEntitiesOfClass(Class<? extends Entity> ... types) {
        for (Class<? extends Entity> type : types) {
            this.killAllEntitiesOfClass(type);
        }
    }

    public void assertItemEntityCountIsAtLeast(Item item, BlockPos pos, double range, int lowerLimit) {
        BlockPos blockpos = this.absolutePos(pos);
        List list = this.getLevel().getEntities((EntityTypeTest)EntityType.ITEM, new AABB(blockpos).inflate(range), Entity::isAlive);
        int count = 0;
        for (ItemEntity itementity : list) {
            ItemStack itemstack = itementity.getItem();
            if (!itemstack.is(item)) continue;
            count += itemstack.getCount();
        }
        if (count < lowerLimit) {
            throw this.assertionException(pos, "Expected at least %s %s items to exist (found %s)", new Object[]{lowerLimit, item.getName().getString(), count});
        }
    }

    public void breakBlock(BlockPos relativePos, ItemStack tool, @Nullable Entity breakingEntity) {
        BlockState state = this.getBlockState(relativePos);
        BlockPos absolutePos = this.absolutePos(relativePos);
        BlockEntity blockEntity = state.hasBlockEntity() ? this.getLevel().getBlockEntity(absolutePos) : null;
        Block.dropResources((BlockState)state, (Level)this.getLevel(), (BlockPos)absolutePos, (BlockEntity)blockEntity, (Entity)breakingEntity, (ItemStack)tool);
        this.getLevel().destroyBlock(absolutePos, false);
    }

    public void boneMeal(BlockPos pos, Player player) {
        this.useOn(pos, Items.BONE_MEAL.getDefaultInstance(), player, Direction.UP);
    }

    public void boneMeal(int x, int y, int z, Player player) {
        this.boneMeal(new BlockPos(x, y, z), player);
    }

    public void boneMealUntilGrown(int x, int y, int z, Player player) {
        this.boneMeal(x, y, z, player);
        this.assertBlockState(new BlockPos(x, y, z), state -> !(state.getBlock() instanceof BonemealableBlock), $ -> Component.translatable((String)"Crop didn't grow"));
    }

    public void assertContainerEmpty(int x, int y, int z) {
        this.assertContainerEmpty(new BlockPos(x, y, z));
    }

    public void assertContainerContains(int x, int y, int z, Item item) {
        this.assertContainerContains(new BlockPos(x, y, z), item);
    }

    public void pulseRedstone(int x, int y, int z, long delay) {
        this.pulseRedstone(new BlockPos(x, y, z), delay);
    }

    public void assertPlayerHasItem(Player player, Item item) {
        this.assertTrue(player.getInventory().hasAnyOf(Set.of(item)), (Component)Component.translatable((String)"Player doesn't have '%s' in their inventory!", (Object[])new Object[]{BuiltInRegistries.ITEM.getKey((Object)item).toString()}));
    }

    public void requireDifficulty(Difficulty difficulty) {
        Difficulty oldDifficulty = this.getLevel().getServer().getWorldData().getDifficulty();
        if (oldDifficulty != difficulty) {
            this.getLevel().getServer().setDifficulty(difficulty, true);
            this.addEndListener(passed -> this.getLevel().getServer().setDifficulty(oldDifficulty, true));
        }
    }

    public void addEndListener(final Consumer<Boolean> listener) {
        this.testInfo.addListener(new GameTestListener(){

            public void testStructureLoaded(GameTestInfo info) {
            }

            public void testPassed(GameTestInfo info, GameTestRunner runner) {
                listener.accept(true);
            }

            public void testFailed(GameTestInfo info, GameTestRunner runner) {
                listener.accept(false);
            }

            public void testAddedForRerun(GameTestInfo p_320937_, GameTestInfo p_320294_, GameTestRunner p_320147_) {
            }
        });
    }

    public <T> T catchException(ThrowingSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (GameTestException exception) {
            throw this.assertionException(exception.getDescription());
        }
        catch (Throwable throwable) {
            throw this.assertionException((Component)Component.literal((String)throwable.getMessage()));
        }
    }

    public void catchException(ThrowingRunnable run) {
        try {
            run.run();
        }
        catch (GameTestException exception) {
            throw this.assertionException(exception.getDescription());
        }
        catch (Throwable throwable) {
            throw this.assertionException((Component)Component.literal((String)throwable.getMessage()));
        }
    }

    public <T extends Entity> T requireEntityAt(EntityType<T> type, int x, int y, int z) {
        return this.requireEntityAt(type, new BlockPos(x, y, z));
    }

    public <T extends Entity> T requireEntityAt(EntityType<T> type, BlockPos pos) {
        List inRange = this.getEntities(type, pos, 2.0);
        this.assertTrue(inRange.size() == 1, (Component)Component.translatable((String)"Only one entity must be present at %s", (Object[])new Object[]{pos.toString()}));
        return (T)((Entity)inRange.getFirst());
    }

    @CanIgnoreReturnValue
    public <T extends Entity> T knockbackResistant(T entity) {
        this.addTemporaryListener(event -> {
            if (event.getEntity().getUUID().equals(entity.getUUID())) {
                event.setCanceled(true);
            }
        });
        return entity;
    }

    public <T extends Event> void addTemporaryListener(Consumer<T> event) {
        NeoForge.EVENT_BUS.addListener(event);
        this.addEndListener(success -> NeoForge.EVENT_BUS.unregister((Object)event));
    }

    public <E extends LivingEntity> void assertMobEffectPresent(E entity, Holder<MobEffect> effect, Component testName) {
        this.assertEntityProperty((Entity)entity, e -> e.hasEffect(effect), testName);
    }

    public <E extends LivingEntity> void assertMobEffectAbsent(E entity, Holder<MobEffect> effect, Component testName) {
        this.assertEntityProperty((Entity)entity, e -> !e.hasEffect(effect), testName);
    }

    public void assertTrue(boolean value, String message) {
        this.assertTrue(value, (Component)Component.translatable((String)message));
    }

    public void assertFalse(boolean value, String message) {
        this.assertFalse(value, (Component)Component.translatable((String)message));
    }

    public void assertNotNull(@Nullable Object var, String message) {
        this.assertTrue(var != null, message);
    }

    public void fail(String message) {
        this.fail((Component)Component.translatable((String)message));
    }

    public void fail(String message, BlockPos pos) {
        this.fail((Component)Component.translatable((String)message), pos);
    }

    public void assertBlock(BlockPos pos, Predicate<Block> predicate, String message) {
        this.assertBlock(pos, predicate, block -> Component.translatable((String)message, (Object[])new Object[]{block}));
    }

    public <T> void assertValueEqual(T expected, T actual, String message) {
        this.assertValueEqual(expected, actual, (Component)Component.translatable((String)message));
    }

    public <T, E extends Entity> void assertEntityProperty(E entity, Function<E, T> function, String message, T value) {
        this.assertEntityProperty(entity, function, value, (Component)Component.translatable((String)message));
    }

    public <E extends Entity> void assertEntityProperty(E entity, Predicate<E> predicate, String message) {
        this.assertEntityProperty(entity, predicate, (Component)Component.translatable((String)message));
    }

    public <T> Holder<T> getHolder(ResourceKey<T> resourceKey) {
        return (Holder)this.getLevel().holder(resourceKey).orElseThrow(() -> this.assertionException("No registered value %s found in loaded data", new Object[]{resourceKey}));
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

