/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.event.RegisterGameTestsEvent;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.TestFramework;
import net.neoforged.testframework.conf.Feature;
import net.neoforged.testframework.gametest.GameTestData;
import net.neoforged.testframework.impl.MutableTestFramework;
import net.neoforged.testframework.impl.ReflectionUtils;
import net.neoforged.testframework.impl.TestFrameworkImpl;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class GameTestRegistration {
    public static void register(RegisterGameTestsEvent event) {
        for (TestFrameworkImpl framework : TestFrameworkImpl.FRAMEWORKS) {
            if (!framework.configuration().isEnabled(Feature.GAMETEST)) continue;
            record TestEntry(Test test, ResourceLocation batchName, GameTestData gameTestData) {
            }
            ListMultimap byBatch = (ListMultimap)framework.tests().all().stream().map(t -> {
                ResourceLocation batch;
                GameTestData data = t.asGameTest();
                if (data == null) {
                    return null;
                }
                if (data.batchName() != null) {
                    batch = data.batchName().contains(":") ? ResourceLocation.parse((String)data.batchName().toLowerCase(Locale.ROOT)) : framework.id().withSuffix(data.batchName().toLowerCase(Locale.ROOT));
                } else {
                    String batchName = !t.groups().isEmpty() ? t.groups().get(0) : "ungrouped";
                    batch = framework.id().withSuffix("/" + batchName.toLowerCase(Locale.ROOT));
                }
                return new TestEntry((Test)t, batch, data);
            }).filter(Objects::nonNull).collect(Multimaps.toMultimap(TestEntry::batchName, Function.identity(), () -> Multimaps.newListMultimap(new HashMap(), ArrayList::new)));
            for (Map.Entry entry : byBatch.asMap().entrySet()) {
                Holder batch = event.registerEnvironment((ResourceLocation)entry.getKey(), new TestEnvironmentDefinition[0]);
                for (TestEntry testEntry : (Collection)entry.getValue()) {
                    Test test = testEntry.test;
                    GameTestData game = testEntry.gameTestData();
                    event.registerTest(framework.id().withSuffix("/" + test.id().toLowerCase(Locale.ROOT)), (GameTestInstance)new Instance((TestData<Holder<TestEnvironmentDefinition>>)new TestData((Object)batch, ResourceLocation.parse((String)game.structureName()), game.maxTicks(), game.setupTicks(), game.required(), game.rotation(), game.manualOnly(), game.maxAttempts(), game.requiredSuccesses(), game.skyAccess()), framework, test.id()));
                }
            }
        }
    }

    static final class Instance
    extends GameTestInstance {
        public static final MapCodec<Instance> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)TestData.CODEC.fieldOf("data").forGetter(rec$ -> ((Instance)((Object)((Object)((Object)rec$)))).info()), (App)MutableTestFramework.REFERENCE_CODEC.fieldOf("framework").forGetter(i -> i.framework), (App)Codec.STRING.fieldOf("testId").forGetter(i -> i.testId)).apply((Applicative)in, Instance::new));
        private final TestFramework framework;
        private final String testId;

        public Instance(TestData<Holder<TestEnvironmentDefinition>> data, TestFramework framework, String testId) {
            super(data);
            this.framework = framework;
            this.testId = testId;
        }

        public void run(GameTestHelper helper) {
            final Test test = this.framework.tests().byId(this.testId).orElseThrow();
            GameTestData game = test.asGameTest();
            try {
                ReflectionUtils.addListener(helper, new GameTestListener(){

                    public void testStructureLoaded(GameTestInfo info) {
                    }

                    public void testPassed(GameTestInfo info, GameTestRunner runner) {
                        if (framework.tests().getStatus(test.id()).result() == Test.Result.NOT_PROCESSED) {
                            framework.changeStatus(test, Test.Status.passed("GameTest passed"), null);
                        }
                        this.disable();
                    }

                    public void testFailed(GameTestInfo info, GameTestRunner runner) {
                        framework.changeStatus(test, Test.Status.failed("GameTest fail: " + info.getError().getMessage()), null);
                        this.disable();
                    }

                    public void testAddedForRerun(GameTestInfo pre, GameTestInfo post, GameTestRunner runner) {
                    }

                    private void disable() {
                        framework.setEnabled(test, false, null);
                    }
                });
                this.framework.setEnabled(test, true, null);
                this.framework.changeStatus(test, Test.Status.DEFAULT, null);
                try {
                    game.function().accept(helper);
                }
                catch (GameTestAssertException assertion) {
                    ((MutableTestFramework)this.framework).tests().setStatus(test.id(), Test.Status.failed("GameTest fail: " + assertion.getMessage()));
                    throw assertion;
                }
            }
            catch (GameTestAssertException exception) {
                this.framework.setEnabled(test, false, null);
                throw exception;
            }
        }

        public MapCodec<? extends GameTestInstance> codec() {
            return CODEC;
        }

        protected MutableComponent typeDescription() {
            return Component.empty();
        }
    }
}

