/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.TestFramework;
import net.neoforged.testframework.gametest.ExtendedGameTestHelper;
import net.neoforged.testframework.gametest.StructureTemplateBuilder;
import net.neoforged.testframework.registration.RegistrationHelper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface DynamicTest
extends Test {
    public TestFramework framework();

    default public Test.Status status() {
        return this.framework().tests().getStatus(this.id());
    }

    default public void updateStatus(Test.Status newStatus, @Nullable Entity updater) {
        this.framework().changeStatus(this, newStatus, updater);
    }

    default public void pass() {
        this.updateStatus(Test.Status.passed(), null);
    }

    default public void fail(String message) {
        this.updateStatus(Test.Status.failed(message), null);
    }

    public void whenEnabled(EnabledListener var1);

    public Test.EventListenerGroup eventListeners();

    public void whenDisabled(Runnable var1);

    default public void onGameTest(Consumer<ExtendedGameTestHelper> consumer) {
        this.onGameTest(ExtendedGameTestHelper.class, consumer);
    }

    public <T extends GameTestHelper> void onGameTest(Class<T> var1, Consumer<T> var2);

    default public void registerGameTestTemplate(StructureTemplateBuilder builder) {
        this.framework().dynamicStructures().register(ResourceLocation.parse((String)this.asGameTest().structureName()), builder.build());
    }

    default public void registerGameTestTemplate(Supplier<StructureTemplateBuilder> builder) {
        this.framework().dynamicStructures().register(ResourceLocation.parse((String)this.asGameTest().structureName()), () -> ((StructureTemplateBuilder)builder.get()).build());
    }

    public RegistrationHelper registrationHelper(String var1);

    public RegistrationHelper registrationHelper();

    public String createModId();

    public boolean isDuringGameTest();

    public void requestConfirmation(Player var1, Component var2);

    @FunctionalInterface
    public static interface EnabledListener {
        public void onEnabled(Test.EventListenerGroup var1);
    }
}

