/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl.packet;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.conf.Feature;
import net.neoforged.testframework.impl.MutableTestFramework;

public record ChangeStatusPayload(MutableTestFramework framework, String testId, Test.Status status) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChangeStatusPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"tf_change_status"));

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.testId);
        buf.writeEnum((Enum)this.status.result());
        buf.writeUtf(this.status.message());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public void handle(IPayloadContext context) {
        switch (context.flow().getReceptionSide()) {
            case CLIENT: {
                this.framework.tests().setStatus(this.testId, this.status);
                break;
            }
            case SERVER: {
                Player player = context.player();
                if (!this.framework.configuration().isEnabled(Feature.CLIENT_MODIFICATIONS) || !Objects.requireNonNull(player.getServer()).getPlayerList().isOp(player.getGameProfile())) break;
                this.framework.tests().byId(this.testId).ifPresent(test -> this.framework.changeStatus((Test)test, this.status, (Entity)player));
            }
        }
    }

    public static ChangeStatusPayload decode(MutableTestFramework framework, FriendlyByteBuf buf) {
        return new ChangeStatusPayload(framework, buf.readUtf(), new Test.Status((Test.Result)buf.readEnum(Test.Result.class), buf.readUtf()));
    }
}

