/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.TestFramework;
import net.neoforged.testframework.conf.FrameworkConfiguration;
import net.neoforged.testframework.group.Group;
import net.neoforged.testframework.impl.PlayerTestStore;
import net.neoforged.testframework.impl.TestFrameworkImpl;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface MutableTestFramework
extends TestFramework {
    public static final Codec<TestFramework> REFERENCE_CODEC = ResourceLocation.CODEC.xmap(rl -> TestFrameworkImpl.FRAMEWORKS.stream().filter(testFramework -> testFramework.id().equals(rl)).findFirst().orElseThrow(), TestFramework::id);

    public FrameworkConfiguration configuration();

    public void init(IEventBus var1, ModContainer var2);

    public void registerCommands(LiteralArgumentBuilder<CommandSourceStack> var1);

    public List<Test> collectTests(ModContainer var1);

    public PlayerTestStore playerTestStore();

    public String commandName();

    default public String buildCommand(String subCommand) {
        return "/" + this.commandName() + " " + subCommand;
    }

    default public ClickEvent setStatusCommand(String testId, Test.Result result, String message) {
        if (message.isBlank()) {
            return new ClickEvent.RunCommand(this.buildCommand("status set \"" + testId + "\" " + String.valueOf((Object)result)));
        }
        return new ClickEvent.RunCommand(this.buildCommand("status set \"" + testId + "\" " + String.valueOf((Object)result) + " " + message));
    }

    default public ClickEvent enableCommand(String id) {
        return new ClickEvent.RunCommand(this.buildCommand("enable " + id));
    }

    default public ClickEvent disableCommand(String id) {
        return new ClickEvent.RunCommand(this.buildCommand("disable " + id));
    }

    @Override
    public MutableTests tests();

    public static interface MutableTests
    extends TestFramework.Tests {
        public void initialiseDefaultEnabledTests();

        public Stream<Test> enabled();

        public Optional<Group> maybeGetGroup(String var1);

        public void setStatus(String var1, Test.Status var2);
    }
}

