/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary.md;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.neoforged.testframework.summary.md.Table;

public class TableRow<T> {
    private final List<T> columns;

    public TableRow() {
        this(new ArrayList());
    }

    public TableRow(List<T> columns) {
        this.columns = columns;
    }

    public String serialize() throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        Iterator<T> itr = this.columns.iterator();
        while (itr.hasNext()) {
            T item = itr.next();
            String asString = item.toString();
            if (asString.contains("|")) {
                throw new IllegalArgumentException("Column contains separator char \"|\"");
            }
            sb.append("|");
            sb.append(Table.surroundWith(asString, " "));
            if (itr.hasNext()) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    public String toString() {
        return this.serialize();
    }

    public List<T> getColumns() {
        return this.columns;
    }
}

