/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public final class FormattingUtil {
    public static String componentToString(Component component, Style baseStyle, BiFunction<Style, String, String> formatter) {
        StringBuilder builder = new StringBuilder();
        component.visit((style, text) -> {
            if (style.isEmpty()) {
                builder.append(text);
            } else {
                builder.append((String)formatter.apply(style, text));
            }
            return Optional.empty();
        }, baseStyle);
        return builder.toString();
    }

    public static String componentToPlainString(Component component) {
        return FormattingUtil.componentToString(component, Style.EMPTY, (style, text) -> text);
    }

    public static String componentToAnsiFormattedText(Component component) {
        return FormattingUtil.componentToString(component, Style.EMPTY, FormattingUtil::toAnsi);
    }

    public static String componentsToAnsiFormattedText(List<Component> components) {
        return components.stream().map(FormattingUtil::componentToAnsiFormattedText).collect(Collectors.joining("\n"));
    }

    public static String componentToMarkdownFormattedText(Component component) {
        return FormattingUtil.componentToString(component, Style.EMPTY, FormattingUtil::toMarkdown);
    }

    public static String componentsToPlainString(List<Component> components) {
        return components.stream().map(FormattingUtil::componentToPlainString).collect(Collectors.joining("\n"));
    }

    public static String componentsToMarkdownFormattedText(List<Component> components) {
        return components.stream().map(FormattingUtil::componentToMarkdownFormattedText).collect(Collectors.joining("</br>"));
    }

    private static String toAnsi(Style style, String text) {
        StringBuilder builder = new StringBuilder();
        if (style.isBold()) {
            builder.append("\u001b[1m");
        }
        if (style.isItalic()) {
            builder.append("\u001b[3m");
        }
        if (style.isUnderlined()) {
            builder.append("\u001b[4m");
        }
        if (style.isStrikethrough()) {
            builder.append("\u001b[9m");
        }
        if (style.getColor() != null) {
            builder.append(Ansi.convertRGBToAnsiCode(style.getColor().getValue()));
        }
        boolean empty = builder.isEmpty();
        builder.append(text);
        if (!empty) {
            builder.append("\u001b[0m");
        }
        return builder.toString();
    }

    private static String toMarkdown(Style style, String text) {
        if (style.isObfuscated()) {
            text = "\\*\\*\\*\\*\\*";
        }
        if (style.isBold()) {
            text = "**" + (String)text + "**";
        }
        if (style.isItalic()) {
            text = "*" + (String)text + "*";
        }
        if (style.isStrikethrough()) {
            text = "~~" + (String)text + "~~";
        }
        if (style.isUnderlined()) {
            text = "<u>" + (String)text + "</u>";
        }
        if (style.getColor() != null) {
            text = "<font color=\"" + style.getColor().toString() + "\">" + (String)text + "</font>";
        }
        return text;
    }

    public static final class Ansi {
        public static final String RESET = "\u001b[0m";
        public static final String BOLD = "\u001b[1m";
        public static final String ITALIC = "\u001b[3m";
        public static final String UNDERLINE = "\u001b[4m";
        public static final String STRIKE = "\u001b[9m";
        private static final int[][] COLORS_RGB = new int[][]{{0, 0, 0}, {128, 0, 0}, {0, 128, 0}, {128, 128, 0}, {0, 0, 128}, {128, 0, 128}, {0, 128, 128}, {192, 192, 192}, {128, 128, 128}, {255, 0, 0}, {0, 255, 0}, {255, 255, 0}, {0, 0, 255}, {255, 0, 255}, {0, 255, 255}, {255, 255, 255}};

        public static String convertRGBToAnsiCode(int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            double minDistance = Double.MAX_VALUE;
            int closestColorIndex1 = 0;
            for (int i = 0; i < COLORS_RGB.length; ++i) {
                int[] ansiColor = COLORS_RGB[i];
                double distance = Ansi.calculateDistance(red, green, blue, ansiColor[0], ansiColor[1], ansiColor[2]);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestColorIndex1 = i;
            }
            int closestColorIndex = closestColorIndex1;
            if (closestColorIndex > 7) {
                return "\u001b[" + (90 + (closestColorIndex - 8)) + "m";
            }
            return "\u001b[" + (30 + closestColorIndex) + "m";
        }

        private static double calculateDistance(int red1, int green1, int blue1, int red2, int green2, int blue2) {
            double[] lab1 = Ansi.xyzToLab(red1, green1, blue1);
            double[] lab2 = Ansi.xyzToLab(red2, green2, blue2);
            double deltaL = lab2[0] - lab1[0];
            double deltaA = lab2[1] - lab1[1];
            double deltaB = lab2[2] - lab1[2];
            return Math.sqrt(deltaL * deltaL + deltaA * deltaA + deltaB * deltaB);
        }

        private static double[] xyzToLab(double r, double g, double b) {
            r /= 255.0;
            g /= 255.0;
            b /= 255.0;
            r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : (r /= 12.92);
            g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : (g /= 12.92);
            b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : (b /= 12.92);
            double x = (r *= 100.0) * 0.4124 + (g *= 100.0) * 0.3576 + (b *= 100.0) * 0.1805;
            double y = r * 0.2126 + g * 0.7152 + b * 0.0722;
            double z = r * 0.0193 + g * 0.1192 + b * 0.9505;
            x /= 95.047;
            y /= 100.0;
            z /= 108.883;
            x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787 * x + 0.13793103448275862;
            y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787 * y + 0.13793103448275862;
            z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787 * z + 0.13793103448275862;
            return new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
        }
    }
}

