/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.testframework.Test;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ApiStatus.Internal
public class EventListenerGroupImpl
implements Test.EventListenerGroup {
    private final Map<EventBusSubscriber.Bus, EventListenerCollectorImpl> collectors = new HashMap<EventBusSubscriber.Bus, EventListenerCollectorImpl>();

    @Override
    public EventListenerCollectorImpl getFor(EventBusSubscriber.Bus bus) {
        return this.collectors.computeIfAbsent(bus, it -> new EventListenerCollectorImpl());
    }

    public void unregister(Map<EventBusSubscriber.Bus, IEventBus> buses) {
        this.collectors.forEach((bus, col) -> col.unregisterAll((IEventBus)buses.get(bus)));
    }

    public void register(Map<EventBusSubscriber.Bus, IEventBus> buses) {
        this.collectors.forEach((bus, col) -> col.registerAll((IEventBus)buses.get(bus)));
    }

    public void copyFrom(EventListenerGroupImpl other) {
        other.collectors.forEach((bus, eventListenerCollector) -> {
            EventListenerCollectorImpl ours = this.getFor((EventBusSubscriber.Bus)bus);
            ours.subscribeActions.addAll(eventListenerCollector.subscribeActions);
            ours.subscribers.addAll(eventListenerCollector.subscribers);
        });
    }

    private static final class EventListenerCollectorImpl
    implements Test.EventListenerGroup.EventListenerCollector {
        private final List<Consumer<IEventBus>> subscribeActions = new ArrayList<Consumer<IEventBus>>();
        private final List<Object> subscribers = new ArrayList<Object>();

        private EventListenerCollectorImpl() {
        }

        @Override
        public void register(Object object) {
            this.subscribeActions.add(bus -> bus.register(object));
            this.subscribers.add(object);
        }

        @Override
        public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
            this.subscribeActions.add(bus -> bus.addListener(priority, receiveCancelled, eventType, consumer));
            this.subscribers.add(consumer);
        }

        @Override
        public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
            this.subscribeActions.add(bus -> bus.addListener(priority, receiveCancelled, consumer));
            this.subscribers.add(consumer);
        }

        @Override
        public void unregisterAll(IEventBus bus) {
            this.subscribers.forEach(arg_0 -> ((IEventBus)bus).unregister(arg_0));
            this.subscribers.clear();
            this.subscribeActions.clear();
        }

        @Override
        public void registerAll(IEventBus bus) {
            this.subscribeActions.forEach(c -> c.accept(bus));
        }
    }
}

