/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.neoforged.testframework.gametest.ExtendedGameTestHelper;
import net.neoforged.testframework.impl.ReflectionUtils;

public interface GameTestHelperFactory<T extends GameTestHelper>
extends Function<GameTestInfo, T> {
    public static final Map<Class<?>, GameTestHelperFactory<?>> CONSTRUCTORS = (Map)Util.make(new IdentityHashMap(), map -> {
        map.put(GameTestHelper.class, GameTestHelper::new);
        map.put(ExtendedGameTestHelper.class, ExtendedGameTestHelper::new);
    });

    public static <T extends GameTestHelper> GameTestHelperFactory<T> forType(Class<T> helperClass) {
        return CONSTRUCTORS.computeIfAbsent(helperClass, c -> {
            MethodHandle constructor;
            try {
                constructor = ReflectionUtils.constructor(c, MethodType.methodType(Void.TYPE, GameTestInfo.class));
            }
            catch (Exception e) {
                LogUtils.getLogger().warn("Failed to create constructor for GameTestHelper: " + String.valueOf(helperClass), (Throwable)e);
                throw new RuntimeException(e);
            }
            return info -> {
                try {
                    return (GameTestHelper)constructor.invokeWithArguments(info);
                }
                catch (Throwable e) {
                    LogUtils.getLogger().warn("Failed to create GameTestHelper: " + String.valueOf(helperClass), e);
                    throw new RuntimeException(e);
                }
            };
        });
    }
}

