/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.registration;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.testframework.registration.RegistrationHelper;

public class DeferredEntityTypeBuilder<E extends Entity, T extends EntityType<E>>
extends DeferredHolder<EntityType<?>, T> {
    private final RegistrationHelper helper;

    protected DeferredEntityTypeBuilder(ResourceKey<EntityType<?>> key, RegistrationHelper helper) {
        super(key);
        this.helper = helper;
    }

    public DeferredEntityTypeBuilder<E, T> withRenderer(Supplier<Function<EntityRendererProvider.Context, EntityRenderer<E, ?>>> renderer) {
        if (FMLLoader.getDist().isClient()) {
            this.helper.eventListeners().accept(event -> event.registerEntityRenderer((EntityType)this.value(), ((Function)renderer.get())::apply));
        }
        return this;
    }

    public DeferredEntityTypeBuilder<E, T> withAttributes(Supplier<AttributeSupplier.Builder> attributes) {
        this.helper.eventListeners().accept(event -> event.put((EntityType)this.get(), ((AttributeSupplier.Builder)attributes.get()).build()));
        return this;
    }

    public DeferredEntityTypeBuilder<E, T> withLang(String name) {
        this.helper.provider(LanguageProvider.class, prov -> prov.add((EntityType)this.value(), name));
        return this;
    }
}

