/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.client;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.testframework.client.TestScreen;
import net.neoforged.testframework.client.TestsOverlay;
import net.neoforged.testframework.conf.ClientConfiguration;
import net.neoforged.testframework.impl.FrameworkClient;
import net.neoforged.testframework.impl.MutableTestFramework;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FrameworkClientImpl
implements FrameworkClient {
    private final MutableTestFramework impl;
    private final ClientConfiguration configuration;

    public FrameworkClientImpl(MutableTestFramework impl, ClientConfiguration clientConfiguration) {
        this.impl = impl;
        this.configuration = clientConfiguration;
    }

    @Override
    public void init(IEventBus modBus, ModContainer container) {
        BooleanSupplier overlayEnabled;
        String keyCategory = "key.categories." + this.impl.id().getNamespace() + "." + this.impl.id().getPath();
        if (this.configuration.toggleOverlayKey() != 0) {
            ToggleKeyMapping overlayKey = new ToggleKeyMapping("key.testframework.toggleoverlay", this.configuration.toggleOverlayKey(), keyCategory, () -> true);
            modBus.addListener(event -> event.register((KeyMapping)overlayKey));
            overlayEnabled = () -> !overlayKey.isDown();
        } else {
            overlayEnabled = () -> true;
        }
        modBus.addListener(event -> event.registerAboveAll(this.impl.id(), (LayeredDraw.Layer)new TestsOverlay(this.impl, overlayEnabled)));
        if (this.configuration.openManagerKey() != 0) {
            KeyMapping openManagerKey = new KeyMapping("key.testframework.openmanager", this.configuration.openManagerKey(), keyCategory){

                public void setDown(boolean pValue) {
                    if (pValue) {
                        Minecraft.getInstance().setScreen((Screen)new TestScreen((Component)Component.literal((String)"All tests"), FrameworkClientImpl.this.impl, List.copyOf(FrameworkClientImpl.this.impl.tests().allGroups())));
                    }
                    super.setDown(pValue);
                }
            };
            modBus.addListener(event -> event.register(openManagerKey));
        }
    }

    public static final class Factory
    implements FrameworkClient.Factory {
        @Override
        public FrameworkClient create(MutableTestFramework impl, ClientConfiguration clientConfiguration) {
            return new FrameworkClientImpl(impl, clientConfiguration);
        }
    }
}

