/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.testframework.TestFramework;
import net.neoforged.testframework.TestListener;
import net.neoforged.testframework.gametest.GameTestData;
import net.neoforged.testframework.group.Groupable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public interface Test
extends Groupable {
    public String id();

    public List<String> groups();

    public boolean enabledByDefault();

    public void onEnabled(EventListenerGroup var1);

    public void onDisabled();

    public void init(TestFramework var1);

    public Visuals visuals();

    @Override
    default public Stream<Test> resolveAsStream() {
        return Stream.of(this);
    }

    @Override
    default public List<Test> resolveAll() {
        return List.of(this);
    }

    default public @Nullable GameTestData asGameTest() {
        return null;
    }

    default public Collection<TestListener> listeners() {
        return List.of();
    }

    public record Visuals(Component title, List<Component> description) {
    }

    public static enum Result {
        PASSED(0x90EE90, "Passed"),
        FAILED(0xFFCCCB, "Failed"),
        NOT_PROCESSED(10920862, "Not Processed");

        private final int color;
        private final String humanReadable;

        private Result(int color, String humanReadable) {
            this.color = color;
            this.humanReadable = humanReadable;
        }

        public int getColor() {
            return this.color;
        }

        public boolean passed() {
            return this == PASSED;
        }

        public boolean failed() {
            return this == FAILED;
        }

        public String asHumanReadable() {
            return this.humanReadable;
        }

        public MutableComponent asComponent() {
            return Component.literal((String)this.asHumanReadable()).withColor(this.color);
        }
    }

    public record Status(Result result, String message, @Nullable Exception exception) {
        public static final Status DEFAULT = new Status(Result.NOT_PROCESSED, "");
        public static final Status PASSED = new Status(Result.PASSED, "");

        public Status(Result result, String message) {
            this(result, message, null);
        }

        public static Status passed(String message) {
            return new Status(Result.PASSED, message);
        }

        public static Status passed() {
            return PASSED;
        }

        public static Status failed(String message) {
            return Status.failed(message, null);
        }

        public static Status failed(String message, @Nullable Exception exception) {
            return new Status(Result.FAILED, message, exception);
        }

        public MutableComponent asComponent() {
            MutableComponent component = this.result().asComponent();
            String message = this.message();
            if (message.isEmpty()) {
                return component;
            }
            return Component.empty().append((Component)component).append(" - " + message);
        }

        @Override
        public String toString() {
            if (this.message.isBlank()) {
                return "[result=" + String.valueOf((Object)this.result) + "]";
            }
            return "[result=" + String.valueOf((Object)this.result) + ",message=" + this.message + ",exception=" + String.valueOf(this.exception) + "]";
        }
    }

    @NullMarked
    public static interface EventListenerGroup {
        public EventListenerCollector mod();

        public EventListenerCollector forge();

        @NullMarked
        public static interface EventListenerCollector {
            public void register(Object var1);

            public void unregisterAll(IEventBus var1);

            public void registerAll(IEventBus var1);

            public <T extends Event> void addListener(EventPriority var1, boolean var2, Class<T> var3, Consumer<T> var4);

            public <T extends Event> void addListener(EventPriority var1, boolean var2, Consumer<T> var3);

            default public <T extends Event> void addListener(Consumer<T> consumer) {
                this.addListener(EventPriority.NORMAL, false, consumer);
            }
        }
    }
}

