/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.group;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.group.Groupable;
import net.neoforged.testframework.impl.TestFrameworkImpl;
import org.jspecify.annotations.Nullable;

public final class Group
implements Groupable {
    private final String id;
    private final List<Groupable> entries;
    private Component title;
    private boolean enabledByDefault;

    public Group(String id, List<Groupable> entries) {
        this.id = id;
        this.entries = entries;
        this.title = this.getDefaultTitle();
    }

    public String id() {
        return this.id;
    }

    public List<Groupable> entries() {
        return this.entries;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    public Component title() {
        return this.title;
    }

    public void setTitle(@Nullable Component title) {
        this.title = title == null ? this.getDefaultTitle() : title;
    }

    public Component getDefaultTitle() {
        return Component.literal((String)TestFrameworkImpl.capitaliseWords(this.id(), "\\."));
    }

    @Override
    public Stream<Test> resolveAsStream() {
        return this.entries.stream().flatMap(gr -> gr.resolveAll().stream());
    }

    public void add(Groupable entry) {
        this.entries.add(entry);
    }
}

