/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.testframework.gametest.TemplateBuilderHelper;
import net.neoforged.testframework.impl.ReflectionUtils;
import org.jspecify.annotations.Nullable;

public class StructureTemplateBuilder
implements TemplateBuilderHelper<StructureTemplateBuilder> {
    private static final FieldHandle<StructureTemplate, List<StructureTemplate.Palette>> PALETTES = FieldHandle.getFor(StructureTemplate.class, "palettes");
    private static final FieldHandle<StructureTemplate, List<StructureTemplate.StructureEntityInfo>> ENTITY_INFO_LIST = FieldHandle.getFor(StructureTemplate.class, "entityInfoList");
    private static final FieldHandle<StructureTemplate, Vec3i> SIZE = FieldHandle.getFor(StructureTemplate.class, "size");
    private static final MethodHandle PALETTE_CONSTRUCTOR = ReflectionUtils.constructor(StructureTemplate.Palette.class, MethodType.methodType(Void.TYPE, List.class));
    private final Vec3i size;
    private final Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks = new LinkedHashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
    private final List<StructureTemplate.StructureEntityInfo> entities = new ArrayList<StructureTemplate.StructureEntityInfo>();

    private StructureTemplateBuilder(Vec3i size) {
        this.size = size;
    }

    public static StructureTemplateBuilder withSize(int length, int height, int width) {
        return new StructureTemplateBuilder(new Vec3i(length, height, width)).fill(0, 0, 0, length - 1, height - 1, width - 1, Blocks.AIR.defaultBlockState());
    }

    public static StructureTemplate empty(int length, int height, int width) {
        return StructureTemplateBuilder.withSize(length, height, width).build();
    }

    public StructureTemplateBuilder fill(int x, int y, int z, int toX, int toY, int toZ, Block block) {
        return this.fill(x, y, z, toX, toY, toZ, block.defaultBlockState());
    }

    public StructureTemplateBuilder fill(int x, int y, int z, int toX, int toY, int toZ, BlockState state) {
        return this.fill(x, y, z, toX, toY, toZ, state, null);
    }

    public StructureTemplateBuilder fill(int x, int y, int z, int toX, int toY, int toZ, BlockState state, @Nullable CompoundTag nbt) {
        for (int x1 = x; x1 <= toX; ++x1) {
            for (int y1 = y; y1 <= toY; ++y1) {
                for (int z1 = z; z1 <= toZ; ++z1) {
                    this.set(x1, y1, z1, state, nbt);
                }
            }
        }
        return this;
    }

    public StructureTemplateBuilder set(int x, int y, int z, BlockState state) {
        return this.set(x, y, z, state, null);
    }

    @Override
    public StructureTemplateBuilder set(int x, int y, int z, BlockState state, @Nullable CompoundTag nbt) {
        if (x < 0 || y < 0 || z < 0 || x >= this.size.getX() || y >= this.size.getY() || z >= this.size.getZ()) {
            throw new IllegalArgumentException("Block position is out of template bounds");
        }
        this.blocks.put(new BlockPos(x, y, z), new StructureTemplate.StructureBlockInfo(new BlockPos(x, y, z), state, nbt));
        return this;
    }

    public StructureTemplate build() {
        StructureTemplate template = new StructureTemplate();
        SIZE.set(template, this.size);
        ENTITY_INFO_LIST.set(template, this.entities);
        try {
            Comparator<StructureTemplate.StructureBlockInfo> comparator = Comparator.comparingInt(block -> block.pos().getY()).thenComparingInt(block -> block.pos().getX()).thenComparingInt(block -> block.pos().getZ());
            ArrayList infos = Lists.newArrayList();
            infos.addAll(this.blocks.values());
            infos.sort(comparator);
            PALETTES.set(template, List.of(PALETTE_CONSTRUCTOR.invokeExact(infos)));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return template;
    }

    public static Supplier<StructureTemplate> lazy(int length, int height, int width, UnaryOperator<StructureTemplateBuilder> consumer) {
        return Suppliers.memoize(() -> ((StructureTemplateBuilder)consumer.apply(StructureTemplateBuilder.withSize(length, height, width))).build());
    }

    private static interface FieldHandle<I, T> {
        public T get(I var1);

        public void set(I var1, T var2);

        public static <I, T> FieldHandle<I, T> getFor(final Class<I> clazz, final String fieldName) {
            Field field = ReflectionUtils.getField(clazz, fieldName);
            final MethodHandle handle = ReflectionUtils.fieldHandle(field);
            return new FieldHandle<I, T>(){

                @Override
                public T get(I instance) {
                    try {
                        return handle.invokeExact(instance);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void set(I instance, T value) {
                    ObfuscationReflectionHelper.setPrivateValue((Class)clazz, instance, value, (String)fieldName);
                }
            };
        }
    }
}

