/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.registration;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.testframework.registration.DeferredItemBuilder;
import net.neoforged.testframework.registration.RegistrationHelper;
import org.jspecify.annotations.Nullable;

public class DeferredBlockBuilder<T extends Block>
extends DeferredBlock<T> {
    private final RegistrationHelper helper;
    private boolean hasItem = false;
    private boolean hasColor = false;

    protected DeferredBlockBuilder(ResourceKey<Block> key, RegistrationHelper helper) {
        super(key);
        this.helper = helper;
    }

    public DeferredBlockBuilder<T> withBlockItem() {
        return this.withBlockItem(UnaryOperator.identity(), (DeferredItemBuilder<BlockItem> c) -> {});
    }

    public DeferredBlockBuilder<T> withBlockItem(Consumer<DeferredItemBuilder<BlockItem>> consumer) {
        return this.withBlockItem(UnaryOperator.identity(), consumer);
    }

    @Deprecated(since="1.21.10", forRemoval=true)
    public DeferredBlockBuilder<T> withBlockItem(Item.Properties properties, Consumer<DeferredItemBuilder<BlockItem>> consumer) {
        return this.withBlockItem(() -> properties, consumer);
    }

    public DeferredBlockBuilder<T> withBlockItem(Supplier<Item.Properties> properties, Consumer<DeferredItemBuilder<BlockItem>> consumer) {
        consumer.accept((DeferredItemBuilder<BlockItem>)this.helper.items().registerSimpleBlockItem((Holder)this, (Supplier)properties));
        this.hasItem = true;
        return this;
    }

    public DeferredBlockBuilder<T> withBlockItem(UnaryOperator<Item.Properties> properties, Consumer<DeferredItemBuilder<BlockItem>> consumer) {
        consumer.accept((DeferredItemBuilder<BlockItem>)this.helper.items().registerSimpleBlockItem((Holder)this, (UnaryOperator)properties));
        this.hasItem = true;
        return this;
    }

    public DeferredBlockBuilder<T> withLang(String name) {
        this.helper.clientProvider(LanguageProvider.class, prov -> prov.add((Block)this.value(), name));
        return this;
    }

    public DeferredBlockBuilder<T> withDefaultWhiteModel() {
        if (!FMLEnvironment.getDist().isClient()) {
            return this;
        }
        this.helper.addClientProvider(event -> event.addProvider((DataProvider)new ModelProvider(event.getGenerator().getPackOutput(), this.helper.modId()){

            protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
                Object template = DeferredBlockBuilder.this.hasColor ? ExtendedModelTemplateBuilder.builder().element(element -> element.from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((face, builder) -> builder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(TextureSlot.ALL).tintindex(0).cullface(face))).requiredTextureSlot(TextureSlot.ALL).build() : ModelTemplates.CUBE_ALL;
                Identifier modelPath = template.create((Block)DeferredBlockBuilder.this.value(), TextureMapping.cube((Identifier)Identifier.fromNamespaceAndPath((String)"testframework", (String)"block/white")), blockModels.modelOutput);
                blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)DeferredBlockBuilder.this.value()), (MultiVariant)BlockModelGenerators.plainVariant((Identifier)modelPath)));
            }

            protected Stream<? extends Holder<Item>> getKnownItems() {
                return DeferredBlockBuilder.this.hasItem ? Stream.of(DeferredBlockBuilder.this.helper.items().createHolder(Registries.ITEM, DeferredBlockBuilder.this.key.identifier())) : Stream.empty();
            }

            protected Stream<? extends Holder<Block>> getKnownBlocks() {
                return Stream.of(DeferredBlockBuilder.this);
            }

            public String getName() {
                return DeferredBlockBuilder.this.key.identifier().toDebugFileName() + "-default-white-model-generator";
            }
        }));
        return this;
    }

    public DeferredBlockBuilder<T> withColor(int color) {
        if (FMLEnvironment.getDist().isClient()) {
            this.colorInternal(color);
        }
        this.hasColor = true;
        return this;
    }

    private void colorInternal(int color) {
        ConstantItemTintSourceBuilder source = new ConstantItemTintSourceBuilder(color);
        this.helper.eventListeners().accept(event -> event.register((p_92567_, p_92568_, p_92569_, p_92570_) -> color, new Block[]{(Block)this.value()}));
        this.helper.eventListeners().accept(event -> {
            if (this.hasItem) {
                event.register(this.key.identifier(), source.type());
            }
        });
    }

    private static final class ConstantItemTintSourceBuilder
    implements ItemTintSource {
        public final MapCodec<ConstantItemTintSourceBuilder> codec = MapCodec.unit((Object)this);
        private final int color;

        private ConstantItemTintSourceBuilder(int color) {
            this.color = color;
        }

        public int calculate(ItemStack p_388652_, @Nullable ClientLevel p_390356_, @Nullable LivingEntity p_390510_) {
            return this.color;
        }

        public MapCodec<? extends ItemTintSource> type() {
            return this.codec;
        }

        public int color() {
            return this.color;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ConstantItemTintSourceBuilder that = (ConstantItemTintSourceBuilder)obj;
            return this.color == that.color;
        }

        public int hashCode() {
            return Objects.hash(this.color);
        }

        public String toString() {
            return "ConstantItemTintSourceBuilder[color=" + this.color + "]";
        }
    }
}

