/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary.md;

import net.neoforged.testframework.summary.md.Table;

public enum Alignment {
    CENTER{

        @Override
        public String align(String str) {
            return ":" + str + ":";
        }

        @Override
        public String fillAligned(String value, String fill, int length) {
            if (value.length() >= length) {
                return value;
            }
            boolean left = true;
            while (value.length() < length) {
                value = left ? LEFT.fillAligned(value, fill, value.length() + 1) : RIGHT.fillAligned(value, fill, value.length() + 1);
                left = !left;
            }
            return value;
        }
    }
    ,
    LEFT{

        @Override
        public String align(String str) {
            return Table.surroundWith(str, " ");
        }

        @Override
        public String fillAligned(String value, String fill, int length) {
            int valLength = value.length();
            if (valLength >= length) {
                return value;
            }
            return value + fill.repeat(length - valLength);
        }
    }
    ,
    RIGHT{

        @Override
        public String align(String str) {
            return " " + str + ":";
        }

        @Override
        public String fillAligned(String value, String fill, int length) {
            int valLength = value.length();
            if (valLength >= length) {
                return value;
            }
            return fill.repeat(length - valLength) + value;
        }
    };


    public abstract String align(String var1);

    public abstract String fillAligned(String var1, String var2, int var3);
}

