/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.testframework.summary.FileSummaryDumper;
import net.neoforged.testframework.summary.FormattingUtil;
import net.neoforged.testframework.summary.TestSummary;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitSummaryDumper
implements FileSummaryDumper {
    private final Path outputDir;

    public JUnitSummaryDumper(Path outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public Path outputPath(ResourceLocation frameworkId) {
        return this.outputDir.resolve("testframework-" + frameworkId.toString().replace(':', '-') + "-" + Instant.now().truncatedTo(ChronoUnit.SECONDS).toString().replaceAll("[:TZ-]", "") + ".junit.xml");
    }

    @Override
    public void write(TestSummary summary, Logger logger, PrintWriter writer) throws ParserConfigurationException, TransformerException {
        Root root = new Root();
        for (TestSummary.TestInfo testInfo : summary.testInfos()) {
            root.add(testInfo);
        }
        ArrayList<Object> suites = new ArrayList<Object>();
        if (!root.testCases.isEmpty()) {
            TestSuite d = new TestSuite(null, "default");
            root.testCases.values().forEach(d::addToSuite);
            suites.add(d);
        }
        for (TestSuite testSuite : root.children.values()) {
            suites.add(testSuite.copy());
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element testsuites = document.createElement("testsuites");
        testsuites.setAttribute("name", summary.framework().id().toString());
        testsuites.setAttribute("tests", Integer.toString(root.tests));
        testsuites.setAttribute("failures", Integer.toString(root.failures));
        testsuites.setAttribute("skipped", Integer.toString(root.skipped));
        for (TestSuite testSuite : suites) {
            testsuites.appendChild(this.toElement(document, testSuite));
        }
        document.appendChild(testsuites);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(writer));
    }

    private Element toElement(Document document, TestSuite suite) {
        Element testsuite = document.createElement("testsuite");
        String path = suite.path();
        testsuite.setAttribute("name", path);
        testsuite.setAttribute("tests", Integer.toString(suite.tests));
        testsuite.setAttribute("failures", Integer.toString(suite.failures));
        testsuite.setAttribute("skipped", Integer.toString(suite.skipped));
        for (TestSuite child : suite.children.values()) {
            testsuite.appendChild(this.toElement(document, child));
        }
        for (TestCase testCase : suite.testCases.values()) {
            testsuite.appendChild(this.toElement(document, path, testCase));
        }
        return testsuite;
    }

    private Element toElement(Document document, String path, TestCase testCase) {
        Element testcase = document.createElement("testcase");
        testcase.setAttribute("name", testCase.name);
        testcase.setAttribute("classname", path);
        Element properties = document.createElement("properties");
        Element desc = document.createElement("property");
        desc.setAttribute("name", "description");
        desc.setTextContent("\n" + FormattingUtil.componentsToPlainString(testCase.info.description()) + "\n");
        properties.appendChild(desc);
        Element step = document.createElement("property");
        switch (testCase.type.ordinal()) {
            case 1: {
                Element failure = document.createElement("failure");
                failure.setAttribute("message", testCase.info.message());
                testcase.appendChild(failure);
                step.setAttribute("name", "step[failure]");
                break;
            }
            case 2: {
                Element skipped = document.createElement("skipped");
                skipped.setAttribute("message", "Failed but optional: " + testCase.info.message());
                testcase.appendChild(skipped);
                step.setAttribute("name", "step[skipped]");
                break;
            }
            case 0: {
                Element passed = document.createElement("passed");
                passed.setAttribute("message", testCase.info.message());
                testcase.appendChild(passed);
                step.setAttribute("name", "step[passed]");
            }
        }
        step.setAttribute("value", testCase.info.message());
        properties.appendChild(step);
        testcase.appendChild(properties);
        return testcase;
    }

    private static class Root
    extends TestSuite {
        private Root() {
            super(null, "default");
        }

        public void add(TestSummary.TestInfo testInfo) {
            List<String> groups = testInfo.groups();
            if (groups.isEmpty()) {
                this.addToSuite(testInfo);
            } else {
                for (String group : groups) {
                    this.addToGroup(group, testInfo);
                }
            }
        }

        private void addToGroup(String groupPath, TestSummary.TestInfo testInfo) {
            String[] parts = groupPath.split("\\.");
            if (parts.length == 0) {
                this.addToSuite(testInfo);
            } else {
                TestSuite curr = this;
                for (String part : parts) {
                    curr = curr.getOrCreate(part);
                }
                curr.addToSuite(testInfo);
            }
        }
    }

    private static class TestSuite {
        final Map<String, TestCase> testCases = new HashMap<String, TestCase>();
        final Map<String, TestSuite> children = new HashMap<String, TestSuite>();
        @Nullable
        final TestSuite parent;
        final String name;
        int tests = 0;
        int failures = 0;
        int skipped = 0;

        private TestSuite(@Nullable TestSuite parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public TestSuite getOrCreate(String groupName) {
            return this.children.computeIfAbsent(groupName, name1 -> new TestSuite(this, (String)name1));
        }

        public void addToSuite(TestSummary.TestInfo info) {
            this.addToSuite(new TestCase(info));
        }

        public void addToSuite(TestCase testCase) {
            this.onAdd(testCase);
            this.testCases.put(testCase.name, testCase);
        }

        private void onAdd(TestCase testCase) {
            ++this.tests;
            switch (testCase.type.ordinal()) {
                case 1: {
                    ++this.failures;
                    break;
                }
                case 2: {
                    ++this.skipped;
                }
            }
            if (this.parent != null) {
                this.parent.onAdd(testCase);
            }
        }

        public String path() {
            return this.parent != null ? this.parent.path() + "." + this.name : this.name;
        }

        public TestSuite copy() {
            TestSuite suite = new TestSuite(null, this.name);
            suite.testCases.putAll(this.testCases);
            suite.children.putAll(this.children);
            suite.tests = this.tests;
            suite.skipped = this.skipped;
            suite.failures = this.failures;
            return suite;
        }
    }

    private static class TestCase {
        final String name;
        final TestSummary.TestInfo info;
        final Type type;

        private TestCase(TestSummary.TestInfo info) {
            this.name = info.testId();
            this.info = info;
            switch (info.result()) {
                case FAILED: {
                    if (info.required()) {
                        this.type = Type.FAILURE;
                        break;
                    }
                    this.type = Type.SKIPPED;
                    break;
                }
                case PASSED: {
                    this.type = Type.PASSED;
                    break;
                }
                default: {
                    this.type = Type.SKIPPED;
                }
            }
        }

        static enum Type {
            PASSED,
            FAILURE,
            SKIPPED;

        }
    }
}

