/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.junit;

import com.google.common.base.Stopwatch;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;

public class EphemeralTestServerProvider
implements ParameterResolver,
Extension {
    public static final AtomicReference<MinecraftServer> SERVER = new AtomicReference();
    public static final AtomicBoolean IN_CONSTRUCTION = new AtomicBoolean();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == MinecraftServer.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return EphemeralTestServerProvider.grabServer();
    }

    public static MinecraftServer grabServer() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer();
        }
        if (IN_CONSTRUCTION.compareAndSet(false, true)) {
            try {
                Path tempDir = Files.createTempDirectory("test-mc-server-", new FileAttribute[0]);
                LevelStorageSource storage = LevelStorageSource.createDefault((Path)tempDir.resolve("world"));
                LevelStorageSource.LevelStorageAccess storageAccess = storage.validateAndCreateAccess("main");
                PackRepository packrepository = ServerPacksSource.createPackRepository((LevelStorageSource.LevelStorageAccess)storageAccess);
                MinecraftServer server = MinecraftServer.spin(thread -> JUnitServer.create(thread, tempDir, storageAccess, packrepository));
                FMLLoader.getCurrent().addCloseCallback(() -> {
                    server.stopServer();
                    LogManager.shutdown();
                });
            }
            catch (Exception ex) {
                LogUtils.getLogger().error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        while (SERVER.get() == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static class JUnitServer
    extends MinecraftServer {
        private static final Logger LOGGER = LogUtils.getLogger();
        private static final Services NO_SERVICES = new Services(null, ServicesKeySet.EMPTY, null, null, null);
        private static final GameRules TEST_GAME_RULES = (GameRules)Util.make((Object)new GameRules(FeatureFlags.REGISTRY.allFlags()), rules -> {
            ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOMOBSPAWNING)).set(false, null);
            ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, null);
        });
        private static final WorldOptions WORLD_OPTIONS = new WorldOptions(0L, false, false);
        private final Path tempDir;
        private final NotificationService notificationService = new NotificationManager();
        private final LocalSampleLogger sampleLogger = new LocalSampleLogger(1);

        public static JUnitServer create(Thread thread, Path tempDir, LevelStorageSource.LevelStorageAccess access, PackRepository resources) {
            resources.reload();
            WorldDataConfiguration config = new WorldDataConfiguration(new DataPackConfig(new ArrayList(resources.getAvailableIds()), List.of()), FeatureFlags.REGISTRY.allFlags());
            LevelSettings levelsettings = new LevelSettings("Test Level", GameType.CREATIVE, false, Difficulty.NORMAL, true, TEST_GAME_RULES, config);
            WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(resources, config, false, true);
            WorldLoader.InitConfig worldloader$initconfig = new WorldLoader.InitConfig(worldloader$packconfig, Commands.CommandSelection.DEDICATED, 4);
            try {
                LOGGER.debug("Starting resource loading");
                Stopwatch stopwatch = Stopwatch.createStarted();
                WorldStem worldstem = (WorldStem)Util.blockUntilDone(exec -> WorldLoader.load((WorldLoader.InitConfig)worldloader$initconfig, ctx -> {
                    Registry registry = new MappedRegistry(Registries.LEVEL_STEM, Lifecycle.stable()).freeze();
                    WorldDimensions.Complete worlddimensions$complete = ((WorldPreset)ctx.datapackWorldgen().lookupOrThrow(Registries.WORLD_PRESET).getOrThrow(WorldPresets.FLAT).value()).createWorldDimensions().bake(registry);
                    return new WorldLoader.DataLoadOutput((Object)new PrimaryLevelData(levelsettings, WORLD_OPTIONS, worlddimensions$complete.specialWorldProperty(), worlddimensions$complete.lifecycle()), worlddimensions$complete.dimensionsRegistryAccess());
                }, WorldStem::new, (Executor)Util.backgroundExecutor(), (Executor)exec)).get();
                stopwatch.stop();
                LOGGER.debug("Finished resource loading after {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                return new JUnitServer(thread, access, resources, worldstem, tempDir);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load vanilla datapack, bit oops", (Throwable)exception);
                System.exit(-1);
                throw new IllegalStateException();
            }
        }

        public JUnitServer(Thread thread, LevelStorageSource.LevelStorageAccess access, PackRepository pack, WorldStem stem, Path tempDir) {
            super(thread, access, pack, stem, Proxy.NO_PROXY, DataFixers.getDataFixer(), NO_SERVICES, (LevelLoadListener)LoggingLevelLoadListener.forDedicatedServer());
            this.tempDir = tempDir;
        }

        public boolean initServer() {
            this.setPlayerList(new PlayerList(this, this, this.registries(), this.playerDataStorage, this.notificationService){});
            ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this);
            LOGGER.info("Started ephemeral JUnit server");
            ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
            return true;
        }

        public void tickServer(BooleanSupplier sup) {
            super.tickServer(sup);
            SERVER.set(this);
        }

        protected void updateEffectiveRespawnData() {
        }

        public boolean saveEverything(boolean p_195515_, boolean p_195516_, boolean p_195517_) {
            return false;
        }

        public void stopServer() {
            LOGGER.info("Stopping server");
            this.getConnection().stop();
            this.getPlayerList().removeAll();
            try {
                this.storageSource.deleteLevel();
                this.storageSource.close();
                FileUtils.deleteDirectory((File)this.tempDir.toFile());
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to unlock level {}", (Object)this.storageSource.getLevelId(), (Object)ioexception);
            }
        }

        public void waitUntilNextTick() {
            this.runAllTasks();
        }

        public SystemReport fillServerSystemReport(SystemReport report) {
            report.setDetail("Type", "Test ephemeral server");
            return report;
        }

        public boolean isHardcore() {
            return false;
        }

        public int operatorUserPermissionLevel() {
            return 0;
        }

        public int getFunctionCompilationLevel() {
            return 4;
        }

        public boolean shouldRconBroadcast() {
            return false;
        }

        public boolean isDedicatedServer() {
            return false;
        }

        public int getRateLimitPacketsPerSecond() {
            return 0;
        }

        public boolean isEpollEnabled() {
            return false;
        }

        public boolean isCommandBlockEnabled() {
            return true;
        }

        public boolean isPublished() {
            return false;
        }

        public boolean shouldInformAdmins() {
            return false;
        }

        public boolean isSingleplayerOwner(NameAndId p_433457_) {
            return false;
        }

        protected SampleLogger getTickTimeLogger() {
            return this.sampleLogger;
        }

        public boolean isTickTimeLoggingEnabled() {
            return false;
        }

        public int getMaxPlayers() {
            return 1;
        }
    }
}

