/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestSequence;
import net.neoforged.testframework.gametest.ExtendedSequence;

public class ParametrizedGameTestSequence<T> {
    private final GameTestHelper helper;
    private final ExtendedSequence sequence;
    private final Supplier<T> value;

    public ParametrizedGameTestSequence(GameTestHelper helper, ExtendedSequence sequence, Supplier<T> value) {
        this.helper = helper;
        this.sequence = sequence;
        AtomicReference capturedException = new AtomicReference();
        AtomicReference val = new AtomicReference();
        sequence.thenExecute(() -> {
            try {
                val.set(value.get());
            }
            catch (Throwable ex) {
                capturedException.set(ex);
                throw ex;
            }
        });
        this.value = () -> {
            Object v = val.get();
            if (v == null) {
                Throwable ex = (Throwable)capturedException.get();
                if (ex != null) {
                    ParametrizedGameTestSequence.sneakyThrow(ex);
                }
                throw helper.assertionException("Expected value to be non-null!", new Object[0]);
            }
            return v;
        };
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(Runnable condition) {
        this.sequence.thenWaitUntil(condition);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(Consumer<T> condition) {
        return this.thenWaitUntil(() -> condition.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(long ticks, Runnable condition) {
        this.sequence.thenWaitUntil(ticks, condition);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(long ticks, Consumer<T> condition) {
        return this.thenWaitUntil(ticks, () -> condition.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenIdle(int amount) {
        return this.thenExecuteAfter(amount, () -> {});
    }

    public ParametrizedGameTestSequence<T> thenExecute(Runnable runnable) {
        this.sequence.thenExecute(runnable);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenExecute(Consumer<T> runnable) {
        return this.thenExecute(() -> runnable.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenExecuteAfter(int ticks, Runnable runnable) {
        this.sequence.thenExecuteAfter(ticks, runnable);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenExecuteAfter(int ticks, Consumer<T> runnable) {
        return this.thenExecuteAfter(ticks, () -> runnable.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenExecuteFor(int ticks, Runnable runnable) {
        this.sequence.thenExecuteFor(ticks, runnable);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenExecuteFor(int ticks, Consumer<T> runnable) {
        return this.thenExecuteFor(ticks, () -> runnable.accept(this.value.get()));
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMap(Function<T, Z> mapper) {
        return new ParametrizedGameTestSequence<Object>(this.helper, this.sequence, () -> mapper.apply(this.value.get()));
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapAfter(int ticks, Function<T, Z> mapper) {
        this.thenIdle(ticks);
        return this.thenMap(mapper);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMap(Supplier<Z> value) {
        return new ParametrizedGameTestSequence<Z>(this.helper, this.sequence, value);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapAfter(int ticks, Supplier<Z> value) {
        this.thenIdle(ticks);
        return this.thenMap(value);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapToSequence(BiFunction<ParametrizedGameTestSequence<T>, Supplier<T>, ParametrizedGameTestSequence<Z>> sequence) {
        AtomicReference value = new AtomicReference();
        this.sequence.thenSequence((ExtendedSequence sq) -> ((ParametrizedGameTestSequence)sequence.apply(new ParametrizedGameTestSequence<T>(this.helper, (ExtendedSequence)((Object)sq), this.value), this.value)).thenExecute(value::set));
        return new ParametrizedGameTestSequence<Object>(this.helper, this.sequence, value::get);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapToSequence(Function<Supplier<T>, ParametrizedGameTestSequence<Z>> sequence) {
        return this.thenMapToSequence((ParametrizedGameTestSequence<T> seq, Supplier<T> val) -> (ParametrizedGameTestSequence)sequence.apply((Supplier)val));
    }

    public ParametrizedGameTestSequence<T> thenSequence(BiConsumer<ParametrizedGameTestSequence<T>, Supplier<T>> sequence) {
        return this.thenSequence((ParametrizedGameTestSequence<T> sq) -> sequence.accept((ParametrizedGameTestSequence<T>)sq, this.value));
    }

    public ParametrizedGameTestSequence<T> thenSequence(Consumer<ParametrizedGameTestSequence<T>> sequence) {
        this.sequence.thenSequence((ExtendedSequence sq) -> sequence.accept(sq.thenMap(this.value)));
        return this;
    }

    public void thenSucceed() {
        this.sequence.thenSucceed();
    }

    public void thenFail(Supplier<GameTestException> exception) {
        this.sequence.thenFail(exception);
    }

    public void thenFail(Function<T, GameTestException> exception) {
        this.thenFail(() -> (GameTestException)((Object)((Object)exception.apply(this.value.get()))));
    }

    public GameTestSequence.Condition thenTrigger() {
        return this.sequence.thenTrigger();
    }

    private static <E extends Throwable> void sneakyThrow(Throwable exception) throws E {
        throw exception;
    }
}

