/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class PlayerTestStore
extends SavedData {
    public static final Codec<PlayerTestStore> FACTORY = ExtraCodecs.converter((DynamicOps)NbtOps.INSTANCE).xmap(PlayerTestStore::decode, PlayerTestStore::save);
    private final Map<UUID, Set<String>> playerToTests = new HashMap<UUID, Set<String>>();

    @Nullable
    public Set<String> getLast(UUID uuid) {
        return this.playerToTests.get(uuid);
    }

    public void put(UUID uuid, Collection<String> tests) {
        this.playerToTests.put(uuid, new HashSet<String>(tests));
        this.setDirty(true);
    }

    public static PlayerTestStore decode(Tag tag) {
        CompoundTag compound = (CompoundTag)tag;
        PlayerTestStore store = new PlayerTestStore();
        CompoundTag testsTag = compound.getCompoundOrEmpty("tests");
        testsTag.keySet().forEach(uuid -> store.put(UUID.fromString(uuid), testsTag.getListOrEmpty(uuid).stream().map(Tag::asString).filter(Optional::isPresent).map(Optional::get).toList()));
        return store;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        CompoundTag testsTag = new CompoundTag();
        this.playerToTests.forEach((uuid, tests) -> {
            ListTag testsNbt = new ListTag();
            tests.forEach(it -> testsNbt.add((Object)StringTag.valueOf((String)it)));
            testsTag.put(uuid.toString(), (Tag)testsNbt);
        });
        tag.put("tests", (Tag)testsTag);
        return tag;
    }
}

