/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.TestFramework;

public record TestSummary(TestFramework framework, boolean isGameTestRun, List<TestInfo> testInfos) {

    public static class Builder {
        private final TestFramework framework;
        private final boolean isGameTestRun;
        private final ImmutableList.Builder<TestInfo> tests = ImmutableList.builder();

        public Builder(TestFramework framework, boolean isGameTestRun) {
            this.framework = framework;
            this.isGameTestRun = isGameTestRun;
        }

        public void addTest(String testId, Component name, List<Component> description, Test.Status status, List<String> groups, boolean enabled, boolean manual, boolean required) {
            this.tests.add((Object)new TestInfo(testId, name, List.copyOf(description), status, groups, enabled, manual, required));
        }

        public TestSummary build() {
            return new TestSummary(this.framework, this.isGameTestRun, (List<TestInfo>)this.tests.build());
        }
    }

    public record TestInfo(String testId, Component name, List<Component> description, Test.Status status, List<String> groups, boolean enabled, boolean manual, boolean required) {
        public Test.Result result() {
            return this.status().result();
        }

        public String message() {
            return this.status().message();
        }
    }
}

