/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.testframework.Test;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ApiStatus.Internal
public class EventListenerGroupImpl
implements Test.EventListenerGroup {
    private final EventListenerCollectorImpl mod = new EventListenerCollectorImpl();
    private final EventListenerCollectorImpl game = new EventListenerCollectorImpl();

    @Override
    public Test.EventListenerGroup.EventListenerCollector mod() {
        return this.mod;
    }

    @Override
    public Test.EventListenerGroup.EventListenerCollector forge() {
        return this.game;
    }

    public void unregister(BusSet set) {
        this.mod.unregisterAll(set.mod);
        this.game.unregisterAll(set.game);
    }

    public void register(BusSet set) {
        this.mod.registerAll(set.mod);
        this.game.registerAll(set.game);
    }

    public void copyFrom(EventListenerGroupImpl other) {
        this.mod.subscribeActions.addAll(other.mod.subscribeActions);
        this.mod.subscribers.addAll(other.mod.subscribers);
        this.game.subscribeActions.addAll(other.game.subscribeActions);
        this.game.subscribers.addAll(other.game.subscribers);
    }

    private static final class EventListenerCollectorImpl
    implements Test.EventListenerGroup.EventListenerCollector {
        private final List<Consumer<IEventBus>> subscribeActions = new ArrayList<Consumer<IEventBus>>();
        private final List<Object> subscribers = new ArrayList<Object>();

        private EventListenerCollectorImpl() {
        }

        @Override
        public void register(Object object) {
            this.subscribeActions.add(bus -> bus.register(object));
            this.subscribers.add(object);
        }

        @Override
        public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Class<T> eventType, Consumer<T> consumer) {
            this.subscribeActions.add(bus -> bus.addListener(priority, receiveCancelled, eventType, consumer));
            this.subscribers.add(consumer);
        }

        @Override
        public <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
            this.subscribeActions.add(bus -> bus.addListener(priority, receiveCancelled, consumer));
            this.subscribers.add(consumer);
        }

        @Override
        public void unregisterAll(IEventBus bus) {
            this.subscribers.forEach(arg_0 -> ((IEventBus)bus).unregister(arg_0));
            this.subscribers.clear();
            this.subscribeActions.clear();
        }

        @Override
        public void registerAll(IEventBus bus) {
            this.subscribeActions.forEach(c -> c.accept(bus));
        }
    }

    public record BusSet(IEventBus mod, IEventBus game) {
    }
}

