/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class PlayerTestStore
extends SavedData {
    public static final SavedData.Factory<PlayerTestStore> FACTORY = new SavedData.Factory(PlayerTestStore::new, (compoundTag, provider) -> new PlayerTestStore().decode((CompoundTag)compoundTag));
    private final Map<UUID, Set<String>> playerToTests = new HashMap<UUID, Set<String>>();

    @Nullable
    public Set<String> getLast(UUID uuid) {
        return this.playerToTests.get(uuid);
    }

    public void put(UUID uuid, Collection<String> tests) {
        this.playerToTests.put(uuid, new HashSet<String>(tests));
        this.setDirty(true);
    }

    public PlayerTestStore decode(CompoundTag tag) {
        CompoundTag testsTag = tag.getCompound("tests");
        testsTag.getAllKeys().forEach(uuid -> this.put(UUID.fromString(uuid), testsTag.getList(uuid, 8).stream().map(Tag::getAsString).toList()));
        return this;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag testsTag = new CompoundTag();
        this.playerToTests.forEach((uuid, tests) -> {
            ListTag testsNbt = new ListTag();
            tests.forEach(it -> testsNbt.add((Object)StringTag.valueOf((String)it)));
            testsTag.put(uuid.toString(), (Tag)testsNbt);
        });
        tag.put("tests", (Tag)testsTag);
        return tag;
    }

    public void save(File file, HolderLookup.Provider prov) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        super.save(file, prov);
    }
}

