/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface EmptyTemplate {
    public String value() default "3x3x3";

    public boolean floor() default false;

    public record Size(int length, int height, int width) {
        public static Size parse(String str) {
            String[] split = str.split("x");
            if (split.length == 0) {
                throw new IllegalArgumentException("Empty size not allowed!");
            }
            if (split.length == 1) {
                int asInt = Integer.parseInt(split[0]);
                return new Size(asInt, asInt, asInt);
            }
            if (split.length == 3) {
                return new Size(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            }
            throw new IllegalArgumentException("Size has too many dimensions: " + split.length);
        }

        @Override
        public String toString() {
            return this.length + "x" + this.height + "x" + this.width;
        }
    }
}

