/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.server.command.EnumArgument;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.group.Group;
import net.neoforged.testframework.group.Groupable;
import net.neoforged.testframework.impl.MutableTestFramework;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record Commands(MutableTestFramework framework) {
    public void register(LiteralArgumentBuilder<CommandSourceStack> node) {
        BiFunction<LiteralArgumentBuilder, Boolean, LiteralArgumentBuilder> commandEnabling = (stack, enabling) -> (LiteralArgumentBuilder)((LiteralArgumentBuilder)stack.requires(it -> it.hasPermission(this.framework.configuration().commandRequiredPermission()))).then(net.minecraft.commands.Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(this.suggestGroupable(it -> {
            if (!(it instanceof Test)) return true;
            Test test = (Test)it;
            if (this.framework.tests().isEnabled(test.id()) == enabling.booleanValue()) return false;
            return true;
        })).executes(ctx -> {
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            this.parseGroupable((CommandSourceStack)ctx.getSource(), id, group -> {
                List<Test> all = group.resolveAll();
                if (all.stream().allMatch(it -> this.framework.tests().isEnabled(it.id()) == enabling.booleanValue())) {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("All tests in group are " + (enabling != false ? "enabled" : "disabled") + "!")));
                } else {
                    all.forEach(test -> this.framework.setEnabled((Test)test, (boolean)enabling, ((CommandSourceStack)ctx.getSource()).getEntity()));
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)((enabling != false ? "Enabled" : "Disabled") + " test group!")), true);
                }
            }, test -> {
                if (this.framework.tests().isEnabled(id) == enabling.booleanValue()) {
                    ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Test is already " + (enabling != false ? "enabled" : "disabled") + "!")));
                } else {
                    this.framework.setEnabled(this.framework.tests().byId(id).orElseThrow(), (boolean)enabling, ((CommandSourceStack)ctx.getSource()).getEntity());
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)((enabling != false ? "Enabled" : "Disabled") + " test!")), true);
                }
            });
            return 1;
        }));
        node.then((ArgumentBuilder)commandEnabling.apply(net.minecraft.commands.Commands.literal((String)"enable"), true));
        node.then((ArgumentBuilder)commandEnabling.apply(net.minecraft.commands.Commands.literal((String)"disable"), false));
        node.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"status").then(net.minecraft.commands.Commands.literal((String)"get").then(net.minecraft.commands.Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(this.suggestTest(test -> this.framework.tests().isEnabled(test.id()))).executes(ctx -> {
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            this.parseGroupable((CommandSourceStack)ctx.getSource(), id, group -> ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"This command does not support groups!")), test -> ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Status of test '").append(id).append("' is: ").append(this.formatStatus(this.framework.tests().getStatus(id))), true));
            return 1;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"set").requires(it -> it.hasPermission(this.framework.configuration().commandRequiredPermission()))).then(net.minecraft.commands.Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests(this.suggestTest(test -> this.framework.tests().isEnabled(test.id()))).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.argument((String)"result", (ArgumentType)EnumArgument.enumArgument(Test.Result.class)).executes(it -> this.processSetStatus((CommandContext<CommandSourceStack>)it, ""))).then(net.minecraft.commands.Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(it -> this.processSetStatus((CommandContext<CommandSourceStack>)it, StringArgumentType.getString((CommandContext)it, (String)"message"))))))));
    }

    private <T> SuggestionProvider<T> suggestGroupable(Predicate<Groupable> predicate) {
        return (context, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            Stream.concat(this.framework.tests().all().stream(), this.framework.tests().allGroups().stream()).filter(predicate).map(groupable -> {
                Object object;
                if (groupable instanceof Test) {
                    Test test = (Test)groupable;
                    object = test.id();
                } else {
                    object = "g:" + ((Group)groupable).id();
                }
                return object;
            }).filter(it -> it.toLowerCase(Locale.ROOT).startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
    }

    private <T> SuggestionProvider<T> suggestTest(Predicate<Test> predicate) {
        return (context, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            this.framework.tests().all().stream().filter(predicate).map(Test::id).filter(it -> it.toLowerCase(Locale.ROOT).startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
    }

    private void parseGroupable(CommandSourceStack stack, String id, Consumer<Group> isGroup, Consumer<Test> isTest) {
        if (id.startsWith("g:")) {
            String grId = id.substring(2);
            this.framework.tests().maybeGetGroup(grId).ifPresentOrElse(isGroup, () -> stack.sendFailure((Component)Component.literal((String)"Unknown test group with id '%s'!".formatted(grId))));
        } else {
            this.framework.tests().byId(id).ifPresentOrElse(isTest, () -> stack.sendFailure((Component)Component.literal((String)"Unknown test with id '%s'!".formatted(id))));
        }
    }

    private Component formatStatus(Test.Status status) {
        MutableComponent resultComponent = Component.literal((String)status.result().toString()).withStyle(style -> style.withColor(status.result().getColor()));
        if (status.message().isBlank()) {
            return resultComponent;
        }
        return resultComponent.append(" - ").append((Component)Component.literal((String)status.message()).withStyle(ChatFormatting.AQUA));
    }

    private int processSetStatus(CommandContext<CommandSourceStack> ctx, String message) {
        String id = StringArgumentType.getString(ctx, (String)"id");
        this.parseGroupable((CommandSourceStack)ctx.getSource(), id, group -> ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"This command does not support groups!")), test -> {
            Test.Result result = (Test.Result)((Object)((Object)ctx.getArgument("result", Test.Result.class)));
            Test.Status status = new Test.Status(result, message);
            this.framework.changeStatus((Test)test, status, ((CommandSourceStack)ctx.getSource()).getEntity());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Status of test '").append(id).append("' has been changed to: ").append(this.formatStatus(status)), true);
        });
        return 1;
    }
}

