/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary.md;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.neoforged.testframework.summary.md.Alignment;
import net.neoforged.testframework.summary.md.TableRow;

public final class Table {
    public static final String SEPARATOR = "|";
    public static final String WHITESPACE = " ";
    public static final String DEFAULT_TRIMMING_INDICATOR = "~";
    public static final int DEFAULT_MINIMUM_COLUMN_WIDTH = 3;
    private final List<TableRow<?>> rows;
    private final List<Alignment> alignments;
    private final boolean firstRowIsHeader;
    private final int minimumColumnWidth;
    private final String trimmingIndicator;

    public static Builder builder() {
        return new Builder();
    }

    public Table(List<TableRow<?>> rows, List<Alignment> alignments, boolean firstRowIsHeader, int minimumColumnWidth, String trimmingIndicator) {
        this.rows = rows;
        this.alignments = alignments;
        this.firstRowIsHeader = firstRowIsHeader;
        this.minimumColumnWidth = minimumColumnWidth;
        this.trimmingIndicator = trimmingIndicator;
    }

    public String serialize() {
        boolean headerSeparatorAdded;
        Map<Integer, Integer> columnWidths = Table.getColumnWidths(this.rows, this.minimumColumnWidth);
        StringBuilder sb = new StringBuilder();
        String headerSeparator = Table.generateHeaderSeparator(columnWidths, this.alignments);
        boolean bl = headerSeparatorAdded = !this.firstRowIsHeader;
        if (!this.firstRowIsHeader) {
            sb.append(headerSeparator).append(System.lineSeparator());
        }
        Iterator<TableRow<?>> itr = this.rows.iterator();
        while (itr.hasNext()) {
            TableRow<?> row = itr.next();
            for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
                sb.append(SEPARATOR);
                String value = "";
                if (row.getColumns().size() > columnIndex) {
                    value = row.getColumns().get(columnIndex).toString();
                }
                if (value.equals(this.trimmingIndicator)) {
                    value = Alignment.LEFT.fillAligned(value, this.trimmingIndicator, columnWidths.get(columnIndex));
                } else {
                    Alignment alignment = Table.getAlignment(this.alignments, columnIndex);
                    value = alignment.fillAligned(value, WHITESPACE, columnWidths.get(columnIndex) + 2);
                }
                sb.append(value);
                if (columnIndex != row.getColumns().size() - 1) continue;
                sb.append(SEPARATOR);
            }
            if (itr.hasNext() || this.rows.size() == 1) {
                sb.append(System.lineSeparator());
            }
            if (headerSeparatorAdded) continue;
            sb.append(headerSeparator).append(System.lineSeparator());
            headerSeparatorAdded = true;
        }
        return sb.toString();
    }

    public String toString() {
        return this.serialize();
    }

    public Table trim(int rowsToKeep) {
        if (this.getRows().size() <= rowsToKeep) {
            return this;
        }
        Table table = this.copy();
        int trimmedEntriesCount = table.getRows().size() - (table.getRows().size() - rowsToKeep);
        int trimmingStartIndex = Math.round((float)trimmedEntriesCount / 2.0f) + 1;
        int trimmingStopIndex = table.getRows().size() - trimmingStartIndex;
        ArrayList trimmedRows = new ArrayList();
        for (int i = trimmingStartIndex; i <= trimmingStopIndex; ++i) {
            trimmedRows.add(table.getRows().get(i));
        }
        table.getRows().removeAll(trimmedRows);
        TableRow trimmingIndicatorRow = new TableRow();
        for (int columnIndex = 0; columnIndex < table.getRows().get(0).getColumns().size(); ++columnIndex) {
            trimmingIndicatorRow.getColumns().add(this.trimmingIndicator);
        }
        table.getRows().add(trimmingStartIndex, trimmingIndicatorRow);
        return table;
    }

    public Table copy() {
        return new Table(new ArrayList(this.getRows()), new ArrayList<Alignment>(this.alignments), this.firstRowIsHeader, this.minimumColumnWidth, this.trimmingIndicator);
    }

    public static String generateHeaderSeparator(Map<Integer, Integer> columnWidths, List<Alignment> alignments) {
        StringBuilder sb = new StringBuilder();
        for (int columnIndex = 0; columnIndex < columnWidths.entrySet().size(); ++columnIndex) {
            sb.append(SEPARATOR);
            sb.append(Table.getAlignment(alignments, columnIndex).align("-".repeat(columnWidths.get(columnIndex))));
            if (columnIndex != columnWidths.entrySet().size() - 1) continue;
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public static Map<Integer, Integer> getColumnWidths(List<TableRow<?>> rows, int minimumColumnWidth) {
        HashMap<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
        if (rows.isEmpty()) {
            return columnWidths;
        }
        for (int columnIndex = 0; columnIndex < rows.get(0).getColumns().size(); ++columnIndex) {
            columnWidths.put(columnIndex, Table.getMaximumItemLength(rows, columnIndex, minimumColumnWidth));
        }
        return columnWidths;
    }

    public static int getMaximumItemLength(List<TableRow<?>> rows, int columnIndex, int minimumColumnWidth) {
        int maximum = minimumColumnWidth;
        for (TableRow<?> row : rows) {
            if (row.getColumns().size() < columnIndex + 1) continue;
            Object value = row.getColumns().get(columnIndex);
            maximum = Math.max(value.toString().length(), maximum);
        }
        return maximum;
    }

    public static Alignment getAlignment(List<Alignment> alignments, int columnIndex) {
        if (alignments.isEmpty()) {
            return Alignment.LEFT;
        }
        if (columnIndex >= alignments.size()) {
            columnIndex = alignments.size() - 1;
        }
        return alignments.get(columnIndex);
    }

    public List<TableRow<?>> getRows() {
        return this.rows;
    }

    public static String surroundWith(String value, String surrounding) {
        return surrounding + value + surrounding;
    }

    public static final class Builder {
        private List<TableRow<?>> rows = new ArrayList();
        private List<Alignment> alignments = new ArrayList<Alignment>();
        private boolean firstRowIsHeader = true;
        private int minimumColumnWidth = 3;
        private String trimmingIndicator = "~";
        private int rowLimit;

        public Builder withRows(List<TableRow<?>> tableRows) {
            this.rows = tableRows;
            return this;
        }

        public Builder addRow(TableRow<?> tableRow) {
            this.rows.add(tableRow);
            return this;
        }

        @SafeVarargs
        public final <T> Builder addRow(T ... objects) {
            TableRow<T> tableRow = new TableRow<T>(Arrays.asList(objects));
            this.rows.add(tableRow);
            return this;
        }

        public Builder withAlignments(List<Alignment> alignments) {
            this.alignments = alignments;
            return this;
        }

        public Builder withAlignments(Alignment ... alignments) {
            return this.withAlignments(Arrays.asList(alignments));
        }

        public Builder withAlignment(Alignment alignment) {
            return this.withAlignments(Collections.singletonList(alignment));
        }

        public Builder withRowLimit(int rowLimit) {
            this.rowLimit = rowLimit;
            return this;
        }

        public Builder withTrimmingIndicator(String trimmingIndicator) {
            this.trimmingIndicator = trimmingIndicator;
            return this;
        }

        public Builder withMinimumColumnWidth(int minimumColumnWidth) {
            this.minimumColumnWidth = minimumColumnWidth;
            return this;
        }

        public Builder useFirstRowAsHeader(boolean firstRowIsHeader) {
            this.firstRowIsHeader = firstRowIsHeader;
            return this;
        }

        public Table build() {
            Table table = new Table(this.rows, this.alignments, this.firstRowIsHeader, this.minimumColumnWidth, this.trimmingIndicator);
            if (this.rowLimit > 0) {
                return table.trim(this.rowLimit);
            }
            return table;
        }

        public String toString() {
            return this.build().toString();
        }
    }
}

