/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.TestListener;
import net.neoforged.testframework.annotation.OnInit;
import net.neoforged.testframework.annotation.TestHolder;
import net.neoforged.testframework.conf.Feature;
import net.neoforged.testframework.conf.FrameworkConfiguration;
import net.neoforged.testframework.conf.MissingDescriptionAction;
import net.neoforged.testframework.gametest.DynamicStructureTemplates;
import net.neoforged.testframework.gametest.GameTestData;
import net.neoforged.testframework.group.Group;
import net.neoforged.testframework.group.Groupable;
import net.neoforged.testframework.impl.Commands;
import net.neoforged.testframework.impl.EventListenerGroupImpl;
import net.neoforged.testframework.impl.FrameworkClient;
import net.neoforged.testframework.impl.FrameworkCollectors;
import net.neoforged.testframework.impl.GameTestRegistration;
import net.neoforged.testframework.impl.LoggerSetup;
import net.neoforged.testframework.impl.MutableTestFramework;
import net.neoforged.testframework.impl.PlayerTestStore;
import net.neoforged.testframework.impl.packet.ChangeEnabledPayload;
import net.neoforged.testframework.impl.packet.ChangeStatusPayload;
import net.neoforged.testframework.impl.packet.TestFrameworkPayloadInitialization;
import net.neoforged.testframework.summary.SummaryDumper;
import net.neoforged.testframework.summary.TestSummary;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ApiStatus.Internal
public class TestFrameworkImpl
implements MutableTestFramework {
    static final Set<TestFrameworkImpl> FRAMEWORKS = Collections.synchronizedSet(new HashSet());
    private final FrameworkConfiguration configuration;
    @Nullable
    private final FrameworkClient client;
    private final Logger logger;
    private final ResourceLocation id;
    private final TestsImpl tests = new TestsImpl();
    @Nullable
    private MinecraftServer server;
    private final DynamicStructureTemplates structures;
    private boolean inClientWorld = false;
    private @UnknownNullability String commandName;
    private @UnknownNullability IEventBus modBus;
    private @UnknownNullability ModContainer container;

    public TestFrameworkImpl(FrameworkConfiguration configuration) {
        FRAMEWORKS.add(this);
        this.configuration = configuration;
        this.id = configuration.id();
        this.structures = new DynamicStructureTemplates();
        this.logger = LoggerFactory.getLogger((String)("TestFramework " + String.valueOf(this.id)));
        new LoggerSetup(this).prepareLogger();
        this.client = FMLLoader.getDist().isClient() && configuration.clientConfiguration() != null ? (FrameworkClient)FrameworkClient.factory().map(it -> it.create(this, configuration.clientConfiguration().get())).orElse(null) : null;
        NeoForge.EVENT_BUS.addListener(event -> {
            this.server = event.getServer();
            this.tests.initialiseDefaultEnabledTests();
            try {
                this.structures.setup(event.getServer().getStructureManager());
            }
            catch (Throwable exception) {
                throw new RuntimeException(exception);
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            MinecraftServer minecraftServer = this.server = event.getServer() == this.server ? null : this.server;
            if (this.configuration().isEnabled(Feature.SUMMARY_DUMP)) {
                boolean isGameTestRun = event.getServer() instanceof GameTestServer;
                TestSummary.Builder builder = new TestSummary.Builder(this.id(), isGameTestRun);
                this.tests().all().forEach(test -> {
                    String id = test.id();
                    Test.Status status = this.tests().getStatus(id);
                    boolean enabled = this.tests().isEnabled(id);
                    GameTestData gameTest = test.asGameTest();
                    Test.Visuals visuals = test.visuals();
                    Component title = visuals.title();
                    List<Component> description = visuals.description();
                    boolean isManual = gameTest == null;
                    builder.addTest(id, title, description, status, test.groups(), enabled || !isManual && isGameTestRun, isManual, !isManual && gameTest.required());
                });
                this.processSummary(builder.build());
            }
            this.logger().info("Test Framework finished.");
        });
        if (this.configuration().isEnabled(Feature.TEST_STORE)) {
            NeoForge.EVENT_BUS.addListener(event -> this.playerTestStore().put(event.getEntity().getUUID(), this.tests.tests.keySet()));
            NeoForge.EVENT_BUS.addListener(event -> {
                Set<String> lastTests = this.playerTestStore().getLast(event.getEntity().getUUID());
                if (lastTests == null) {
                    return;
                }
                Sets.SetView newTests = Sets.difference(this.tests.tests.keySet(), lastTests);
                if (newTests.isEmpty()) {
                    return;
                }
                MutableComponent message = Component.literal((String)"Welcome, ").append(event.getEntity().getName()).append("!").append("\nThis server has the test framework enabled, so here are some of the tests that were added in your absence:\n");
                Iterator tests = newTests.stream().limit(20L).flatMap(it -> this.tests().byId((String)it).stream()).map(it -> Component.literal((String)"- ").append(it.visuals().title()).append(" - ").append((Component)(this.tests().isEnabled(it.id()) ? Component.literal((String)"disable").withStyle(style -> style.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)).withClickEvent(this.disableCommand(it.id()))) : Component.literal((String)"enable").withStyle(style -> style.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)).withClickEvent(this.enableCommand(it.id())))))).iterator();
                while (tests.hasNext()) {
                    Component current = (Component)tests.next();
                    message = message.append(current);
                    if (!tests.hasNext()) continue;
                    message = message.append("\n");
                }
                event.getEntity().sendSystemMessage((Component)message);
            });
        }
    }

    private void processSummary(TestSummary summary) {
        for (SummaryDumper formatter : this.configuration().dumpers()) {
            if (!formatter.enabled(summary)) continue;
            formatter.dump(summary, this.logger);
        }
    }

    @Override
    public void registerCommands(LiteralArgumentBuilder<CommandSourceStack> node) {
        this.commandName = node.getLiteral();
        new Commands(this).register(node);
    }

    @Override
    public PlayerTestStore playerTestStore() {
        return (PlayerTestStore)this.server.overworld().getDataStorage().computeIfAbsent(PlayerTestStore.FACTORY, "tests/" + this.id().getNamespace() + "_" + this.id().getPath());
    }

    @Override
    public DynamicStructureTemplates dynamicStructures() {
        return this.structures;
    }

    @Override
    public String commandName() {
        return this.commandName;
    }

    @Override
    public FrameworkConfiguration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(IEventBus modBus, ModContainer container) {
        this.container = container;
        SetMultimap<OnInit.Stage, Consumer<MutableTestFramework>> byStage = FrameworkCollectors.onInitMethodsWithAnnotation(container);
        this.modBus = modBus;
        this.tests.buses = Map.of(EventBusSubscriber.Bus.GAME, NeoForge.EVENT_BUS, EventBusSubscriber.Bus.MOD, modBus);
        byStage.get((Object)OnInit.Stage.BEFORE_SETUP).forEach(cons -> cons.accept(this));
        List<Test> collected = this.collectTests(container);
        this.logger.info("Found {} tests: {}", (Object)collected.size(), (Object)String.join((CharSequence)", ", collected.stream().map(Test::id).toList()));
        collected.forEach(this.tests()::register);
        FrameworkCollectors.groupsWithAnnotation(container, data -> {
            Group group = this.tests().getOrCreateGroup(data.id());
            group.setTitle(data.title());
            group.setEnabledByDefault(data.isEnabledByDefault());
            for (String parent : data.parents()) {
                this.tests().getOrCreateGroup(parent).add(group);
            }
        });
        modBus.addListener(new TestFrameworkPayloadInitialization(this)::onNetworkSetup);
        modBus.addListener(event -> event.register(GameTestRegistration.REGISTER_METHOD));
        Set<String> set = this.tests().enabled;
        synchronized (set) {
            List.copyOf(this.tests().enabled).forEach(this.tests()::disable);
        }
        this.tests().initialiseDefaultEnabledTests();
        if (FMLLoader.getDist().isClient()) {
            TestFrameworkImpl.setupClient(this, modBus, container);
        }
        FrameworkCollectors.templatesWithAnnotation(container, this.structures::register);
        byStage.get((Object)OnInit.Stage.AFTER_SETUP).forEach(cons -> cons.accept(this));
    }

    private static void setupClient(TestFrameworkImpl impl, IEventBus modBus, ModContainer container) {
        if (impl.client != null) {
            impl.client.init(modBus, container);
        }
        NeoForge.EVENT_BUS.addListener(logIn -> {
            Set<String> set = impl.tests().enabled;
            synchronized (set) {
                List.copyOf(impl.tests().enabled).forEach(impl.tests()::disable);
            }
            impl.tests().initialiseDefaultEnabledTests();
            impl.inClientWorld = true;
        });
        NeoForge.EVENT_BUS.addListener(logOut -> {
            impl.inClientWorld = false;
        });
    }

    @Override
    public List<Test> collectTests(ModContainer container) {
        ArrayList<Test> tests = new ArrayList<Test>();
        tests.addAll(FrameworkCollectors.Tests.eventTestMethodsWithAnnotation(container, TestHolder.class));
        tests.addAll(FrameworkCollectors.Tests.forMethodsWithAnnotation(container, TestHolder.class));
        tests.addAll(FrameworkCollectors.Tests.forGameTestMethodsWithAnnotation(container, TestHolder.class));
        tests.addAll(FrameworkCollectors.Tests.forClassesWithAnnotation(container, TestHolder.class));
        return tests;
    }

    @Override
    public IEventBus modEventBus() {
        return this.modBus;
    }

    @Override
    public ModContainer container() {
        return this.container;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public TestsImpl tests() {
        return this.tests;
    }

    @Override
    public void changeStatus(Test test, Test.Status newStatus, @Nullable Entity changer) {
        Object object;
        Test.Status oldStatus = this.tests.getStatus(test.id());
        if (oldStatus.equals(newStatus)) {
            return;
        }
        if (!this.tests.isEnabled(test.id())) {
            return;
        }
        this.tests.setStatus(test.id(), newStatus);
        this.tests.globalListeners.forEach(listener -> listener.onStatusChange(this, test, oldStatus, newStatus, changer));
        test.listeners().forEach(listener -> listener.onStatusChange(this, test, oldStatus, newStatus, changer));
        Object[] objectArray = new Object[3];
        objectArray[0] = test.id();
        objectArray[1] = newStatus;
        if (changer instanceof Player) {
            Player player = (Player)changer;
            object = " by " + player.getGameProfile().getName();
        } else {
            object = "";
        }
        objectArray[2] = object;
        this.logger.info("Status of test '{}' has had status changed to {}{}.", objectArray);
        if (this.server == null && !this.inClientWorld) {
            return;
        }
        ChangeStatusPayload packet = new ChangeStatusPayload(this, test.id(), newStatus);
        this.sendPacketIfOn(() -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]), () -> PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
    }

    @Override
    public void setEnabled(Test test, boolean enabled, @Nullable Entity changer) {
        Object object;
        if (this.tests.isEnabled(test.id()) == enabled) {
            return;
        }
        if (enabled) {
            this.tests.enable(test.id());
        } else {
            this.tests.disable(test.id());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = test.id();
        Object object2 = objectArray[1] = enabled ? "enabled" : "disabled";
        if (changer instanceof Player) {
            Player player = (Player)changer;
            object = " by " + player.getGameProfile().getName();
        } else {
            object = "";
        }
        objectArray[2] = object;
        this.logger.info("Test '{}' has been {}{}.", objectArray);
        if (enabled) {
            this.changeStatus(test, Test.Status.DEFAULT, changer);
        }
        Consumer<TestListener> listenerConsumer = enabled ? listener -> listener.onEnabled(this, test, changer) : listener -> listener.onDisabled(this, test, changer);
        this.tests.globalListeners.forEach(listenerConsumer);
        test.listeners().forEach(listenerConsumer);
        ChangeEnabledPayload packet = new ChangeEnabledPayload(this, test.id(), enabled);
        this.sendPacketIfOn(() -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]), () -> PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
    }

    private void sendPacketIfOn(@Nullable Runnable onServer, @Nullable Runnable remoteClient, @Nullable Runnable singlePlayer) {
        if (FMLLoader.getDist().isClient() && this.server != null) {
            if (singlePlayer != null) {
                singlePlayer.run();
            }
        } else if (FMLLoader.getDist().isClient()) {
            if (remoteClient != null && this.configuration.isEnabled(Feature.CLIENT_MODIFICATIONS)) {
                remoteClient.run();
            }
        } else if (FMLLoader.getDist().isDedicatedServer() && this.server != null && onServer != null && this.configuration.isEnabled(Feature.CLIENT_SYNC)) {
            onServer.run();
        }
    }

    public static String capitaliseWords(String string, String splitOn) {
        return Stream.of(string.split(splitOn)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public final class TestsImpl
    implements MutableTestFramework.MutableTests {
        private final Map<String, Test> tests = Collections.synchronizedMap(new LinkedHashMap());
        private final Map<String, Group> groups = Collections.synchronizedMap(new LinkedHashMap());
        private final Map<String, EventListenerGroupImpl> collectors = new HashMap<String, EventListenerGroupImpl>();
        private final Set<String> enabled = Collections.synchronizedSet(new LinkedHashSet());
        private final Map<String, Test.Status> statuses = new ConcurrentHashMap<String, Test.Status>();
        private Map<EventBusSubscriber.Bus, IEventBus> buses = Map.of();
        private final Set<TestListener> globalListeners = new HashSet<TestListener>();
        private final Collection<Test> allView = Collections.unmodifiableCollection(this.tests.values());

        @Override
        public void addListener(TestListener listener) {
            this.globalListeners.add(listener);
        }

        @Override
        public Optional<Test> byId(String id) {
            return Optional.ofNullable(this.tests.get(id));
        }

        @Override
        public Group getOrCreateGroup(String id) {
            @Nullable Group group = this.groups.get(id);
            if (group != null) {
                return group;
            }
            group = this.addGroupToParents(new Group(id, new CopyOnWriteArrayList<Groupable>()));
            this.groups.put(id, group);
            return group;
        }

        @Override
        public Optional<Group> maybeGetGroup(String id) {
            return Optional.ofNullable(this.groups.get(id));
        }

        @Override
        public Collection<Group> allGroups() {
            return this.groups.values();
        }

        @Override
        public void enable(String id) {
            if (this.enabled.contains(id)) {
                return;
            }
            EventListenerGroupImpl collector = this.collectors.computeIfAbsent(id, it -> new EventListenerGroupImpl());
            this.byId(id).ifPresent(test -> test.onEnabled(collector));
            collector.register(this.buses);
            this.enabled.add(id);
        }

        @Override
        public void disable(String id) {
            if (!this.enabled.contains(id)) {
                return;
            }
            this.byId(id).ifPresent(Test::onDisabled);
            Optional.ofNullable(this.collectors.get(id)).ifPresent(col -> col.unregister(this.buses));
            this.enabled.remove(id);
        }

        @Override
        public boolean isEnabled(String id) {
            return this.enabled.contains(id);
        }

        @Override
        public Test.Status getStatus(String testId) {
            return this.statuses.getOrDefault(testId, Test.Status.DEFAULT);
        }

        @Override
        public void setStatus(String testId, Test.Status status) {
            this.statuses.put(testId, status);
        }

        @Override
        public void register(Test test) {
            if (this.tests.containsKey(test.id())) {
                throw new UnsupportedOperationException("Duplicate test with ID: " + test.id());
            }
            if (test.visuals() == null || test.visuals().description() == null || test.visuals().description().isEmpty()) {
                if (TestFrameworkImpl.this.configuration.onMissingDescription() == MissingDescriptionAction.ERROR) {
                    throw new IllegalStateException("Test '" + test.id() + "' has no description.");
                }
                if (TestFrameworkImpl.this.configuration.onMissingDescription() == MissingDescriptionAction.WARNING) {
                    TestFrameworkImpl.this.logger.warn("Test '{}' has no description.", (Object)test.id());
                }
            }
            this.tests.put(test.id(), test);
            if (test.groups().isEmpty()) {
                this.getOrCreateGroup("ungrouped").add(test);
            } else {
                test.groups().forEach(group -> this.getOrCreateGroup((String)group).add(test));
            }
            test.init(TestFrameworkImpl.this);
        }

        private Group addGroupToParents(Group group) {
            List<String> splitOnDot = List.of(group.id().split("\\."));
            if (splitOnDot.size() >= 2) {
                Group parent = this.getOrCreateGroup(String.join((CharSequence)".", splitOnDot.subList(0, splitOnDot.size() - 1)));
                parent.add(group);
            }
            return group;
        }

        @Override
        public Collection<Test> all() {
            return this.allView;
        }

        @Override
        public Stream<Test> enabled() {
            return this.enabled.stream().flatMap(it -> this.byId((String)it).stream());
        }

        @Override
        public void initialiseDefaultEnabledTests() {
            this.enabled.clear();
            Predicate<Test> isEnabledByDefault = Test::enabledByDefault;
            HashSet<String> enabledTests = new HashSet<String>(TestFrameworkImpl.this.configuration.enabledTests());
            HashSet<Group> enabledGroups = new HashSet<Group>();
            Iterator etestsItr = enabledTests.iterator();
            while (etestsItr.hasNext()) {
                String next = (String)etestsItr.next();
                if (!next.startsWith("g:")) continue;
                enabledGroups.add(this.getOrCreateGroup(next.substring(2)));
                etestsItr.remove();
            }
            enabledGroups.addAll(this.groups.values().stream().filter(Group::isEnabledByDefault).toList());
            Set groupTestsEnabledByDefault = enabledGroups.stream().flatMap(it -> it.resolveAll().stream()).collect(Collectors.toSet());
            isEnabledByDefault = isEnabledByDefault.or(it -> enabledTests.contains(it.id()));
            isEnabledByDefault = isEnabledByDefault.or(groupTestsEnabledByDefault::contains);
            for (Test test : this.tests.values()) {
                if (isEnabledByDefault.test(test)) {
                    this.enable(test.id());
                }
                this.setStatus(test.id(), Test.Status.DEFAULT);
            }
        }
    }
}

