/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl.test;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.impl.ReflectionUtils;
import net.neoforged.testframework.impl.test.AbstractTest;

public class MethodBasedEventTest
extends AbstractTest.Dynamic {
    protected MethodHandle handle;
    private final Method method;
    private final Class<? extends Event> eventClass;
    private final EventBusSubscriber.Bus bus;
    private final EventPriority priority;
    private final boolean receiveCancelled;

    public MethodBasedEventTest(Method method) {
        this.method = method;
        this.configureFrom(AbstractTest.AnnotationHolder.method(method));
        this.eventClass = method.getParameterTypes()[0];
        this.bus = IModBusEvent.class.isAssignableFrom(this.eventClass) ? EventBusSubscriber.Bus.MOD : EventBusSubscriber.Bus.GAME;
        SubscribeEvent seAnnotation = method.getAnnotation(SubscribeEvent.class);
        if (seAnnotation == null) {
            this.priority = EventPriority.NORMAL;
            this.receiveCancelled = false;
        } else {
            this.priority = seAnnotation.priority();
            this.receiveCancelled = seAnnotation.receiveCanceled();
        }
        this.handle = ReflectionUtils.handle(method);
    }

    public MethodBasedEventTest bindTo(Object target) {
        this.handle = this.handle.bindTo(target);
        return this;
    }

    @Override
    public void onEnabled(Test.EventListenerGroup buses) {
        super.onEnabled(buses);
        buses.getFor(this.bus).addListener(this.priority, this.receiveCancelled, this.eventClass, event -> {
            try {
                this.handle.invoke((Event)event, this);
            }
            catch (Throwable throwable) {
                this.framework.logger().warn("Encountered exception firing event listeners for method-based event test {}: ", (Object)this.method, (Object)throwable);
            }
        });
    }
}

