/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.testframework.impl.ReflectionUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DynamicStructureTemplates {
    private static final String SOURCES_FIELD = "sources";
    private final Map<ResourceLocation, Supplier<StructureTemplate>> templates = new ConcurrentHashMap<ResourceLocation, Supplier<StructureTemplate>>();

    public void setup(StructureTemplateManager manager) throws Throwable {
        ArrayList<Object> sources = new ArrayList<Object>((Collection)ReflectionUtils.getInstanceField(manager, SOURCES_FIELD));
        Class sourceClazz = Stream.of(StructureTemplateManager.class.getDeclaredClasses()).filter(it -> it.getSimpleName().equals("Source")).findFirst().orElseThrow();
        MethodHandle ctor = ReflectionUtils.constructor(sourceClazz, MethodType.methodType(Void.TYPE, Function.class, Supplier.class));
        Function<ResourceLocation, Optional> loader = this::load;
        Supplier<Stream> lister = this::list;
        sources.add(ctor.invokeWithArguments(loader, lister));
        ObfuscationReflectionHelper.setPrivateValue(StructureTemplateManager.class, (Object)manager, sources, (String)SOURCES_FIELD);
        LogUtils.getLogger().debug("Injected dynamic template source in manager {}", (Object)manager);
    }

    private Optional<StructureTemplate> load(ResourceLocation location) {
        Supplier<StructureTemplate> sup = this.templates.get(location);
        if (sup == null) {
            return Optional.empty();
        }
        return Optional.of(sup.get());
    }

    private Stream<ResourceLocation> list() {
        return this.templates.keySet().stream();
    }

    public boolean contains(ResourceLocation id) {
        return this.templates.containsKey(id);
    }

    public void register(ResourceLocation id, Supplier<StructureTemplate> template) {
        this.templates.put(id, template);
    }

    public void register(ResourceLocation id, StructureTemplate template) {
        this.register(id, () -> template);
    }
}

