/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import com.mojang.authlib.GameProfile;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;

public class GameTestPlayer
extends ServerPlayer
implements GameTestListener {
    private final GameTestHelper helper;
    private final List<Consumer<? extends Event>> listeners = new ArrayList<Consumer<? extends Event>>();

    public GameTestPlayer(MinecraftServer server, ServerLevel level, GameProfile profile, ClientInformation information, GameTestHelper helper) {
        super(server, level, profile, information);
        this.helper = helper;
    }

    public void moveTo(double x, double y, double z) {
        super.moveTo(x, y, z);
        this.serverLevel().getChunkSource().move((ServerPlayer)this);
        this.connection.chunkSender.sendNextChunks((ServerPlayer)this);
        this.connection.chunkSender.onChunkBatchReceivedByClient(64.0f);
    }

    public GameTestPlayer moveToCorner() {
        this.moveTo(this.helper.absoluteVec(new BlockPos(0, this.helper.testInfo.getStructureName().endsWith("_floor") ? 2 : 1, 0).getCenter()).subtract(0.0, 0.5, 0.0));
        return this;
    }

    public GameTestPlayer moveToCentre() {
        Vec3i size = this.helper.testInfo.getStructureBlockEntity().getStructureSize();
        this.moveTo(this.helper.absoluteVec(new BlockPos(size.getX() / 2, this.helper.testInfo.getStructureName().endsWith("_floor") ? 2 : 1, size.getX() / 2).getCenter()).subtract(0.0, 0.5, 0.0));
        return this;
    }

    public GameTestPlayer preventItemPickup() {
        this.subscribe(event -> {
            if (event.getPlayer() == this) {
                event.setCanPickup(TriState.FALSE);
            }
        });
        return this;
    }

    public void testStructureLoaded(GameTestInfo i) {
    }

    public void testPassed(GameTestInfo i, GameTestRunner runner) {
        this.disconnectGameTest();
    }

    public void testFailed(GameTestInfo i, GameTestRunner runner) {
        this.disconnectGameTest();
    }

    public void testAddedForRerun(GameTestInfo i, GameTestInfo i2, GameTestRunner runner) {
    }

    public void subscribe(Consumer<? extends Event> listener) {
        this.listeners.add(listener);
        NeoForge.EVENT_BUS.addListener(listener);
    }

    private void disconnectGameTest() {
        this.connection.disconnect((Component)Component.literal((String)"Test finished"));
        this.listeners.forEach(arg_0 -> ((IEventBus)NeoForge.EVENT_BUS).unregister(arg_0));
        this.listeners.clear();
    }

    private Stream<Packet<? extends ClientCommonPacketListener>> outboundPackets() {
        return ((EmbeddedChannel)this.connection.connection.channel()).outboundMessages().stream().filter(Packet.class::isInstance).map(obj -> (Packet)obj).flatMap(packet -> {
            if (!(packet instanceof ClientboundBundlePacket)) {
                return Stream.of(packet);
            }
            ClientboundBundlePacket clientboundBundlePacket = (ClientboundBundlePacket)packet;
            return StreamSupport.stream(clientboundBundlePacket.subPackets().spliterator(), false).map(obj -> obj);
        });
    }

    public <T extends Packet<? extends ClientCommonPacketListener>> Stream<T> getOutboundPackets(Class<T> type) {
        return this.outboundPackets().filter(type::isInstance).map(type::cast);
    }

    public <T extends CustomPacketPayload> Stream<T> getOutboundPayloads(Class<T> type) {
        return this.getOutboundPackets(ClientboundCustomPayloadPacket.class).map(ClientboundCustomPayloadPacket::payload).filter(type::isInstance).map(type::cast);
    }
}

