/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.registration;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.testframework.registration.RegistrationHelper;

public class DeferredItemBuilder<I extends Item>
extends DeferredItem<I> {
    private final RegistrationHelper registrationHelper;

    protected DeferredItemBuilder(ResourceKey<Item> key, RegistrationHelper registrationHelper) {
        super(key);
        this.registrationHelper = registrationHelper;
    }

    public DeferredItemBuilder<I> withLang(String name) {
        this.registrationHelper.provider(LanguageProvider.class, prov -> prov.add((Item)this.value(), name));
        return this;
    }

    public DeferredItemBuilder<I> tab(ResourceKey<CreativeModeTab> tab) {
        this.registrationHelper.eventListeners().accept(event -> {
            if (event.getTabKey() == tab) {
                event.accept((ItemLike)this);
            }
        });
        return this;
    }

    public DeferredItemBuilder<I> withModel(Consumer<ItemModelBuilder> modelConsumer) {
        this.registrationHelper.provider(ItemModelProvider.class, prov -> modelConsumer.accept((ItemModelBuilder)prov.getBuilder(this.key.location().toString())));
        return this;
    }
}

