/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl.reg;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlags;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.testframework.registration.DeferredAttachmentTypes;
import net.neoforged.testframework.registration.DeferredBlocks;
import net.neoforged.testframework.registration.DeferredEntityTypes;
import net.neoforged.testframework.registration.DeferredItems;
import net.neoforged.testframework.registration.RegistrationHelper;

public class RegistrationHelperImpl
implements RegistrationHelper {
    private final ModContainer owner;
    private static final Map<Class<?>, DataGenProvider<?>> PROVIDERS;
    private final String modId;
    private final ListMultimap<Class<?>, Consumer<? extends DataProvider>> providers = Multimaps.newListMultimap(new IdentityHashMap(), ArrayList::new);
    private final List<Function<GatherDataEvent, DataProvider>> directProviders = new ArrayList<Function<GatherDataEvent, DataProvider>>();
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> registrars = new ConcurrentHashMap();
    private DeferredBlocks blocks;
    private DeferredItems items;
    private DeferredEntityTypes entityTypes;
    private final DeferredRegistrar<AttachmentType<?>, DeferredAttachmentTypes> attachments = new DeferredRegistrar((namespace, reg) -> new DeferredAttachmentTypes((String)namespace));
    private IEventBus bus;
    private final List<Consumer<? extends Event>> listeners = new ArrayList<Consumer<? extends Event>>();

    public RegistrationHelperImpl(String modId, ModContainer owner) {
        this.modId = modId;
        this.owner = owner;
    }

    public RegistrationHelperImpl(String modId) {
        this(modId, null);
    }

    @Override
    public <T> DeferredRegister<T> registrar(ResourceKey<Registry<T>> registry) {
        return this.registrars.computeIfAbsent(registry, k -> {
            DeferredRegister dr = DeferredRegister.create((ResourceKey)registry, (String)this.modId);
            if (this.bus != null) {
                dr.register(this.bus);
            }
            return dr;
        });
    }

    @Override
    public DeferredBlocks blocks() {
        if (this.blocks == null) {
            this.blocks = new DeferredBlocks(this.modId, this);
            this.registrars.put((ResourceKey<Registry<?>>)Registries.BLOCK, (DeferredRegister<?>)this.blocks);
            if (this.bus != null) {
                this.blocks.register(this.bus);
            }
        }
        return this.blocks;
    }

    @Override
    public DeferredItems items() {
        if (this.items == null) {
            this.items = new DeferredItems(this.modId, this);
            this.registrars.put((ResourceKey<Registry<?>>)Registries.ITEM, (DeferredRegister<?>)this.items);
            if (this.bus != null) {
                this.items.register(this.bus);
            }
        }
        return this.items;
    }

    @Override
    public DeferredEntityTypes entityTypes() {
        if (this.entityTypes == null) {
            this.entityTypes = new DeferredEntityTypes(this.modId, this);
            this.registrars.put(Registries.ENTITY_TYPE, this.entityTypes);
            if (this.bus != null) {
                this.entityTypes.register(this.bus);
            }
        }
        return this.entityTypes;
    }

    @Override
    public DeferredAttachmentTypes attachments() {
        return this.attachments.get();
    }

    @Override
    public <M extends DataMapType<?, ?>> M registerDataMap(M map) {
        this.eventListeners().accept(event -> event.register(map));
        return map;
    }

    @Override
    public String modId() {
        return this.modId;
    }

    @Override
    public String registerSubpack(String name) {
        String newName = this.modId + "_" + name;
        this.eventListeners().accept(event -> {
            if (event.getPackType() == PackType.SERVER_DATA) {
                event.addRepositorySource(acceptor -> acceptor.accept(new Pack(new PackLocationInfo(newName, (Component)Component.literal((String)newName), PackSource.BUILT_IN, Optional.empty()), (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(this.owner.getModInfo().getOwningFile().getFile().findResource(new String[]{newName})), new Pack.Metadata((Component)Component.empty(), PackCompatibility.COMPATIBLE, FeatureFlags.DEFAULT_FLAGS, List.of(), true), new PackSelectionConfig(true, Pack.Position.TOP, true))));
            }
        });
        return newName;
    }

    @Override
    public <T extends DataProvider> void provider(Class<T> type, Consumer<T> consumer) {
        this.providers.put(type, consumer);
    }

    @Override
    public void addProvider(Function<GatherDataEvent, DataProvider> provider) {
        this.directProviders.add(provider);
    }

    @Override
    public void register(IEventBus bus) {
        this.bus = bus;
        bus.addListener(this::gather);
        this.listeners.forEach(arg_0 -> ((IEventBus)bus).addListener(arg_0));
        this.registrars.values().forEach(r -> r.register(bus));
    }

    @Override
    public Consumer<Consumer<? extends Event>> eventListeners() {
        return this.bus == null ? this.listeners::add : arg_0 -> ((IEventBus)this.bus).addListener(arg_0);
    }

    private void gather(GatherDataEvent event) {
        this.providers.asMap().forEach((cls, cons) -> event.getGenerator().addProvider(true, PROVIDERS.get(cls).create(event.getGenerator().getPackOutput(), event.getLookupProvider(), event.getGenerator(), event.getExistingFileHelper(), this.modId, (List)cons)));
        this.directProviders.forEach(func -> event.getGenerator().addProvider(true, new DataProvider(){
            final DataProvider p;
            final /* synthetic */ Function val$func;
            final /* synthetic */ GatherDataEvent val$event;
            {
                this.val$func = function;
                this.val$event = gatherDataEvent;
                this.p = (DataProvider)this.val$func.apply(this.val$event);
            }

            public CompletableFuture<?> run(CachedOutput output) {
                return this.p.run(output);
            }

            public String getName() {
                return RegistrationHelperImpl.this.modId + " generator " + this.p.getName();
            }
        }));
    }

    static {
        IdentityHashMap providers = new IdentityHashMap();
        class ProviderRegistrar {
            final /* synthetic */ Map val$providers;

            ProviderRegistrar(Map map) {
                this.val$providers = map;
            }

            <T extends DataProvider> void register(Class<T> type, DataGenProvider<T> provider) {
                this.val$providers.put(type, provider);
            }
        }
        ProviderRegistrar reg = new ProviderRegistrar(providers);
        reg.register(LanguageProvider.class, (output, registries, generator, existingFileHelper, modId, consumers) -> new LanguageProvider(output, modId, "en_us"){

            protected void addTranslations() {
                consumers.forEach(c -> c.accept(this));
            }
        });
        reg.register(BlockStateProvider.class, (output, registries, generator, existingFileHelper, modId, consumers) -> new BlockStateProvider(output, modId, existingFileHelper){

            protected void registerStatesAndModels() {
                existingFileHelper.trackGenerated(new ResourceLocation("testframework:block/white"), (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
                consumers.forEach(c -> c.accept(this));
            }
        });
        reg.register(ItemModelProvider.class, (output, registries, generator, existingFileHelper, modId, consumers) -> new ItemModelProvider(output, modId, existingFileHelper){

            protected void registerModels() {
                consumers.forEach(c -> c.accept(this));
            }
        });
        reg.register(GlobalLootModifierProvider.class, (output, registries, generator, existingFileHelper, modId, consumers) -> new GlobalLootModifierProvider(output, registries, modId){

            protected void start() {
                consumers.forEach(c -> c.accept(this));
            }
        });
        PROVIDERS = Map.copyOf(providers);
    }

    private final class DeferredRegistrar<R, T extends DeferredRegister<R>>
    implements Supplier<T> {
        private final BiFunction<String, RegistrationHelper, T> factory;
        private T cached;

        private DeferredRegistrar(BiFunction<String, RegistrationHelper, T> factory) {
            this.factory = factory;
        }

        @Override
        public T get() {
            if (this.cached == null) {
                this.cached = (DeferredRegister)this.factory.apply(RegistrationHelperImpl.this.modId, RegistrationHelperImpl.this);
                RegistrationHelperImpl.this.registrars.put((ResourceKey<Registry<?>>)this.cached.getRegistryKey(), (DeferredRegister<?>)this.cached);
                if (RegistrationHelperImpl.this.bus != null) {
                    this.cached.register(RegistrationHelperImpl.this.bus);
                }
            }
            return this.cached;
        }
    }

    private static interface DataGenProvider<T extends DataProvider> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, DataGenerator var3, ExistingFileHelper var4, String var5, List<Consumer<T>> var6);
    }
}

