/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.client;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.client.AbstractTestScreen;
import net.neoforged.testframework.group.Group;
import net.neoforged.testframework.impl.MutableTestFramework;

public class TestScreen
extends AbstractTestScreen {
    protected EditBox searchTextField;
    private final List<Group> groups;
    protected AbstractTestScreen.GroupableList groupableList;
    private Consumer<String> suggestionProvider;
    protected CycleButton<Boolean> showAsGroup;
    protected CycleButton<FilterMode> filterMode;
    private static boolean isGroup = true;

    public TestScreen(Component title, MutableTestFramework framework, List<Group> groups) {
        super(title, framework);
        this.groups = groups;
    }

    protected void init() {
        Runnable reloader = () -> {
            this.groupableList.resetRows(this.searchTextField.getValue());
            this.groupableList.setScrollAmount(0.0);
        };
        this.showAsGroup = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.booleanBuilder((Component)Component.literal((String)"Show groups"), (Component)Component.literal((String)"Show all tests")).displayOnlyValue().withInitialValue((Object)isGroup).create(20, this.height - 26, 100, 20, (Component)Component.empty(), (pCycleButton, pValue) -> {
            reloader.run();
            isGroup = pValue;
        }));
        this.filterMode = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(mode -> mode.name).withValues((Object[])FilterMode.values()).create((this.width - 160) / 2, this.height - 26, 150, 20, (Component)Component.literal((String)"Filter"), (pCycleButton, pValue) -> reloader.run()));
        List tests = this.groups.stream().flatMap(it -> it.resolveAll().stream()).distinct().toList();
        this.groupableList = new AbstractTestScreen.GroupableList(this, () -> (Boolean)this.showAsGroup.getValue(), this.groups, () -> tests.stream().filter(test -> ((FilterMode)this.filterMode.getValue()).test(this.framework, test)), this.minecraft, this.width, this.height - 90, 50, 15);
        this.suggestionProvider = s -> {
            if (((Boolean)this.showAsGroup.getValue()).booleanValue()) {
                TestScreen.updateSearchTextFieldSuggestion(this.searchTextField, s, this.groups, gr -> gr.title().getString());
            } else {
                TestScreen.updateSearchTextFieldSuggestion(this.searchTextField, s, tests, test -> test.visuals().title().getString());
            }
        };
        this.groupableList.resetRows("");
        this.addRenderableWidget((GuiEventListener)this.groupableList);
        this.searchTextField = new EditBox(this.font, this.width / 2 - 110, 22, 220, 20, (Component)Component.literal((String)"Search"));
        this.searchTextField.setResponder(s -> {
            this.suggestionProvider.accept((String)s);
            this.groupableList.resetRows(s.toLowerCase(Locale.ROOT));
            if (!s.isEmpty()) {
                this.groupableList.setScrollAmount(0.0);
            }
        });
        this.addWidget((GuiEventListener)this.searchTextField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Disable"), pButton -> ((AbstractTestScreen.GroupableList.Entry)this.groupableList.getSelected()).enable(false)).bounds(this.searchTextField.getX() - 43, this.searchTextField.getY(), 40, 20).build(builder -> new Button((Button.Builder)builder){

            public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
                this.active = TestScreen.this.groupableList != null && TestScreen.this.groupableList.getSelected() != null && ((AbstractTestScreen.GroupableList.Entry)TestScreen.this.groupableList.getSelected()).canDisable();
                super.renderWidget(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
        }));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Enable"), pButton -> ((AbstractTestScreen.GroupableList.Entry)this.groupableList.getSelected()).enable(true)).bounds(this.searchTextField.getX() + this.searchTextField.getWidth() + 3, this.searchTextField.getY(), 40, 20).build(builder -> new Button((Button.Builder)builder){

            public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
                this.active = TestScreen.this.groupableList != null && TestScreen.this.groupableList.getSelected() != null && ((AbstractTestScreen.GroupableList.Entry)TestScreen.this.groupableList.getSelected()).canEnable();
                super.renderWidget(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
        }));
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (((Boolean)this.showAsGroup.getValue()).booleanValue()) {
            this.filterMode.visible = false;
            this.filterMode.active = false;
        } else {
            this.filterMode.visible = true;
            this.filterMode.active = true;
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.searchTextField.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        pPoseStack.drawCenteredString(this.font, this.getTitle(), this.width / 2, 7, 0xFFFFFF);
    }

    public static <T> void updateSearchTextFieldSuggestion(EditBox editBox, String value, List<T> entries, Function<T, String> nameProvider) {
        if (!value.isEmpty()) {
            Optional<String> optional = entries.stream().filter(info -> ((String)nameProvider.apply(info)).toLowerCase(Locale.ROOT).startsWith(value.toLowerCase(Locale.ROOT))).map(nameProvider).min(Comparator.naturalOrder());
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get();
                editBox.setSuggestion(displayName.substring(length));
            } else {
                editBox.setSuggestion("");
            }
        } else {
            editBox.setSuggestion("Search");
        }
    }

    public static enum FilterMode implements BiPredicate<MutableTestFramework, Test>
    {
        ALL("All"){

            @Override
            public boolean test(MutableTestFramework framework, Test test) {
                return true;
            }
        }
        ,
        NOT_PROCESSED("Not Processed"){

            @Override
            public boolean test(MutableTestFramework framework, Test test) {
                return framework.tests().getStatus(test.id()).result() == Test.Result.NOT_PROCESSED;
            }
        }
        ,
        PASSED("Passed"){

            @Override
            public boolean test(MutableTestFramework framework, Test test) {
                return framework.tests().getStatus(test.id()).result().passed();
            }
        }
        ,
        FAILED("Failed"){

            @Override
            public boolean test(MutableTestFramework framework, Test test) {
                return framework.tests().getStatus(test.id()).result() == Test.Result.FAILED;
            }
        }
        ,
        ENABLED("Enabled"){

            @Override
            public boolean test(MutableTestFramework framework, Test test) {
                return framework.tests().isEnabled(test.id());
            }
        }
        ,
        DISABLED("Disabled"){

            @Override
            public boolean test(MutableTestFramework framework, Test test) {
                return !framework.tests().isEnabled(test.id());
            }
        };

        private Component name;

        private FilterMode(String name) {
            this.name = Component.literal((String)name);
        }
    }
}

