/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.gametest;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestSequence;
import net.neoforged.testframework.gametest.ExtendedSequence;

public class ParametrizedGameTestSequence<T> {
    private final GameTestInfo info;
    private final ExtendedSequence sequence;
    private final Supplier<T> value;

    public ParametrizedGameTestSequence(GameTestInfo info, ExtendedSequence sequence, Supplier<T> value) {
        this.info = info;
        this.sequence = sequence;
        AtomicReference val = new AtomicReference();
        sequence.thenExecute(() -> val.set(value.get()));
        this.value = () -> {
            Object v = val.get();
            if (v == null) {
                throw new GameTestAssertException("Expected value to be non-null!");
            }
            return v;
        };
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(Runnable condition) {
        this.sequence.thenWaitUntil(condition);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(Consumer<T> condition) {
        return this.thenWaitUntil(() -> condition.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(long ticks, Runnable condition) {
        this.sequence.thenWaitUntil(ticks, condition);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenWaitUntil(long ticks, Consumer<T> condition) {
        return this.thenWaitUntil(ticks, () -> condition.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenIdle(int amount) {
        return this.thenExecuteAfter(amount, () -> {});
    }

    public ParametrizedGameTestSequence<T> thenExecute(Runnable runnable) {
        this.sequence.thenExecute(runnable);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenExecute(Consumer<T> runnable) {
        return this.thenExecute(() -> runnable.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenExecuteAfter(int ticks, Runnable runnable) {
        this.sequence.thenExecuteAfter(ticks, runnable);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenExecuteAfter(int ticks, Consumer<T> runnable) {
        return this.thenExecuteAfter(ticks, () -> runnable.accept(this.value.get()));
    }

    public ParametrizedGameTestSequence<T> thenExecuteFor(int ticks, Runnable runnable) {
        this.sequence.thenExecuteFor(ticks, runnable);
        return this;
    }

    public ParametrizedGameTestSequence<T> thenExecuteFor(int ticks, Consumer<T> runnable) {
        return this.thenExecuteFor(ticks, () -> runnable.accept(this.value.get()));
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMap(Function<T, Z> mapper) {
        return new ParametrizedGameTestSequence<Object>(this.info, this.sequence, () -> mapper.apply(this.value.get()));
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapAfter(int ticks, Function<T, Z> mapper) {
        this.thenIdle(ticks);
        return this.thenMap(mapper);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMap(Supplier<Z> value) {
        return new ParametrizedGameTestSequence<Z>(this.info, this.sequence, value);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapAfter(int ticks, Supplier<Z> value) {
        this.thenIdle(ticks);
        return this.thenMap(value);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapToSequence(BiFunction<ParametrizedGameTestSequence<T>, Supplier<T>, ParametrizedGameTestSequence<Z>> sequence) {
        AtomicReference value = new AtomicReference();
        this.sequence.thenSequence((ExtendedSequence sq) -> ((ParametrizedGameTestSequence)sequence.apply(new ParametrizedGameTestSequence<T>(this.info, (ExtendedSequence)((Object)sq), this.value), this.value)).thenExecute(value::set));
        return new ParametrizedGameTestSequence<Object>(this.info, this.sequence, value::get);
    }

    public <Z> ParametrizedGameTestSequence<Z> thenMapToSequence(Function<Supplier<T>, ParametrizedGameTestSequence<Z>> sequence) {
        return this.thenMapToSequence((ParametrizedGameTestSequence<T> seq, Supplier<T> val) -> (ParametrizedGameTestSequence)sequence.apply((Supplier)val));
    }

    public ParametrizedGameTestSequence<T> thenSequence(BiConsumer<ParametrizedGameTestSequence<T>, Supplier<T>> sequence) {
        return this.thenSequence((ParametrizedGameTestSequence<T> sq) -> sequence.accept((ParametrizedGameTestSequence<T>)sq, this.value));
    }

    public ParametrizedGameTestSequence<T> thenSequence(Consumer<ParametrizedGameTestSequence<T>> sequence) {
        this.sequence.thenSequence((ExtendedSequence sq) -> sequence.accept(sq.thenMap(this.value)));
        return this;
    }

    public void thenSucceed() {
        this.sequence.thenSucceed();
    }

    public void thenFail(Supplier<Exception> exception) {
        this.sequence.thenFail(exception);
    }

    public void thenFail(Function<T, Exception> exception) {
        this.thenFail(() -> (Exception)exception.apply(this.value.get()));
    }

    public GameTestSequence.Condition thenTrigger() {
        return this.sequence.thenTrigger();
    }
}

