/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.registration;

import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.testframework.registration.DeferredItemBuilder;
import net.neoforged.testframework.registration.RegistrationHelper;

public class DeferredBlockBuilder<T extends Block>
extends DeferredBlock<T> {
    private final RegistrationHelper helper;
    private boolean hasItem = false;
    private boolean hasColor = false;

    protected DeferredBlockBuilder(ResourceKey<Block> key, RegistrationHelper helper) {
        super(key);
        this.helper = helper;
    }

    public DeferredBlockBuilder<T> withBlockItem() {
        return this.withBlockItem(new Item.Properties(), c -> {});
    }

    public DeferredBlockBuilder<T> withBlockItem(Consumer<DeferredItemBuilder<BlockItem>> consumer) {
        return this.withBlockItem(new Item.Properties(), consumer);
    }

    public DeferredBlockBuilder<T> withBlockItem(Item.Properties properties, Consumer<DeferredItemBuilder<BlockItem>> consumer) {
        consumer.accept((DeferredItemBuilder<BlockItem>)this.helper.items().registerSimpleBlockItem((Holder)this, properties));
        this.hasItem = true;
        return this;
    }

    public DeferredBlockBuilder<T> withLang(String name) {
        this.helper.provider(LanguageProvider.class, prov -> prov.add((Block)this.value(), name));
        return this;
    }

    public DeferredBlockBuilder<T> withDefaultWhiteModel() {
        this.helper.provider(BlockStateProvider.class, prov -> {
            BlockModelBuilder model = this.hasColor ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder(this.key.location().getPath())).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").tintindex(0).cullface(direction)).end()).texture("all", new ResourceLocation("testframework:block/white"))).texture("particle", new ResourceLocation("testframework:block/white")) : (BlockModelBuilder)prov.models().cubeAll(this.key.location().getPath(), new ResourceLocation("testframework:block/white"));
            if (this.hasItem) {
                prov.simpleBlockWithItem((Block)this.value(), (ModelFile)model);
            } else {
                prov.simpleBlock((Block)this.value(), (ModelFile)model);
            }
        });
        return this;
    }

    public DeferredBlockBuilder<T> withColor(int color) {
        if (FMLLoader.getDist().isClient()) {
            this.colorInternal(color);
        }
        this.hasColor = true;
        return this;
    }

    private void colorInternal(int color) {
        this.helper.eventListeners().accept(event -> event.register((p_92567_, p_92568_, p_92569_, p_92570_) -> color, new Block[]{(Block)this.value()}));
        this.helper.eventListeners().accept(event -> {
            if (this.hasItem) {
                event.register((stack, index) -> color, new ItemLike[]{(ItemLike)this.value()});
            }
        });
    }
}

