/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.client;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.client.ClientUtils;
import net.neoforged.testframework.client.CommitBasedList;
import net.neoforged.testframework.impl.MutableTestFramework;

public final class TestsOverlay
implements LayeredDraw.Layer {
    public static final int MAX_DISPLAYED = 5;
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("testframework", "textures/gui/background.png");
    private final MutableTestFramework impl;
    private final BooleanSupplier enabled;
    private final Object2FloatMap<Test> fading = new Object2FloatOpenHashMap();
    private final List<Test> lastRenderedTests = new ArrayList<Test>(5);
    static final Map<Test.Result, ResourceLocation> ICON_BY_RESULT = new EnumMap<Test.Result, ResourceLocation>(Map.of(Test.Result.FAILED, new ResourceLocation("testframework", "textures/gui/test_failed.png"), Test.Result.PASSED, new ResourceLocation("testframework", "textures/gui/test_passed.png"), Test.Result.NOT_PROCESSED, new ResourceLocation("testframework", "textures/gui/test_not_processed.png")));

    public TestsOverlay(MutableTestFramework impl, BooleanSupplier enabled) {
        this.impl = impl;
        this.enabled = enabled;
        this.fading.defaultReturnValue(1.0f);
    }

    public void render(GuiGraphics poseStack, float partialTick) {
        if (!this.enabled.getAsBoolean()) {
            return;
        }
        List enabled = this.impl.tests().enabled().collect(Collectors.toCollection(ArrayList::new));
        if (enabled.isEmpty()) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int startX = 10;
        int startY = 10;
        int maxWidth = poseStack.guiWidth() / 3;
        int x = 10;
        int y = 10;
        int maxX = x;
        CommitBasedList renderingQueue = new CommitBasedList(new ArrayList());
        MutableComponent title = Component.literal((String)"Tests overlay for ").append((Component)Component.literal((String)this.impl.id().toString()).withStyle(ChatFormatting.AQUA));
        renderingQueue.addDirectly(this.withXY(x, y, (arg_0, arg_1) -> TestsOverlay.lambda$render$0(poseStack, font, (Component)title, arg_0, arg_1)));
        Objects.requireNonNull(font);
        y += 9 + 5;
        maxX += font.width((FormattedText)title);
        if (enabled.size() > 5) {
            int nullIndex;
            List actuallyToRender;
            Map lastCompleted = this.lastRenderedTests.stream().filter(it -> this.impl.tests().getStatus(it.id()).result() == Test.Result.PASSED).collect(Collectors.toMap(Function.identity(), this.lastRenderedTests::indexOf));
            ArrayList finalActuallyToRender = actuallyToRender = new ArrayList(5);
            for (int i = 0; i < 5; ++i) {
                actuallyToRender.add(null);
            }
            lastCompleted.forEach((test, index) -> finalActuallyToRender.set((int)index, test));
            enabled.stream().filter(it -> this.impl.tests().getStatus(it.id()).result() != Test.Result.PASSED).limit(5 - lastCompleted.size()).forEach(it -> finalActuallyToRender.set(finalActuallyToRender.indexOf(null), it));
            while ((nullIndex = actuallyToRender.indexOf(null)) >= 0) {
                actuallyToRender.remove(nullIndex);
            }
            for (Test test2 : List.copyOf(actuallyToRender)) {
                renderingQueue.push();
                int lastY = y;
                int lastMaxX = maxX;
                if (this.impl.tests().getStatus(test2.id()).result() == Test.Result.PASSED) {
                    float fade = this.fading.computeIfAbsent((Object)test2, it -> 1.0f) - 0.005f;
                    if (fade <= 0.0f) {
                        this.fading.removeFloat((Object)test2);
                        actuallyToRender.remove(test2);
                        continue;
                    }
                    renderingQueue.add(() -> {
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                    });
                    XY xy = this.renderTest(font, test2, poseStack, maxWidth, x, y, (int)(fade * 255.0f) << 24 | 0xFFFFFF, renderingQueue.currentProgress());
                    y = xy.y() + 5;
                    maxX = Math.max(maxX, xy.x());
                    renderingQueue.add(RenderSystem::disableBlend);
                    this.fading.put((Object)test2, fade);
                } else {
                    XY xy = this.renderTest(font, test2, poseStack, maxWidth, x, y, 0xFFFFFF, renderingQueue.currentProgress());
                    y = xy.y() + 5;
                    maxX = Math.max(maxX, xy.x());
                }
                if (y >= poseStack.guiHeight()) {
                    int endIndex = actuallyToRender.indexOf(test2) + 1;
                    if (y > poseStack.guiHeight()) {
                        --endIndex;
                        renderingQueue.revert();
                        y = lastY;
                        maxX = lastMaxX;
                    } else {
                        renderingQueue.popAndCommit();
                    }
                    actuallyToRender = actuallyToRender.subList(0, endIndex);
                    break;
                }
                renderingQueue.popAndCommit();
            }
            this.lastRenderedTests.clear();
            this.lastRenderedTests.addAll(actuallyToRender);
        } else {
            for (Test test3 : enabled) {
                int lastY = y;
                int lastMaxX = maxX;
                renderingQueue.push();
                XY xy = this.renderTest(font, test3, poseStack, maxWidth, x, y, 0xFFFFFF, renderingQueue.currentProgress());
                y = xy.y() + 5;
                maxX = Math.max(maxX, xy.x());
                if (y >= poseStack.guiHeight()) {
                    int endIndex = enabled.indexOf(test3) + 1;
                    if (y > poseStack.guiHeight()) {
                        renderingQueue.revert();
                        y = lastY;
                        maxX = lastMaxX;
                        --endIndex;
                    } else {
                        renderingQueue.popAndCommit();
                    }
                    enabled = enabled.subList(0, endIndex);
                    break;
                }
                renderingQueue.popAndCommit();
            }
            this.lastRenderedTests.clear();
            this.lastRenderedTests.addAll(enabled);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        TestsOverlay.renderTilledTexture(poseStack, BG_TEXTURE, 6, 6, (maxX += 3) - 10 + 4 + 4, y - 10 + 4, 4, 4, 256, 256, 0.5f);
        renderingQueue.forEach(Runnable::run);
        RenderSystem.disableBlend();
    }

    private XY renderTest(Font font, Test test, GuiGraphics stack, int maxWidth, int x, int y, int colour, List<Runnable> rendering) {
        Test.Status status = this.impl.tests().getStatus(test.id());
        FormattedCharSequence bullet = Component.literal((String)"- ").withStyle(ChatFormatting.BLACK).getVisualOrderText();
        rendering.add(this.withXY(x, y, (x$, y$) -> stack.drawString(font, bullet, x$, y$ - 1, colour)));
        rendering.add(this.withXY(x += font.width(bullet) + 1, y, (x$, y$) -> stack.blit(ICON_BY_RESULT.get((Object)status.result()), x$, y$, 0.0f, 0.0f, 9, 9, 9, 9)));
        MutableComponent title = TestsOverlay.statusColoured(test.visuals().title(), status);
        rendering.add(this.withXY(x += 11, y, (arg_0, arg_1) -> TestsOverlay.lambda$renderTest$9(stack, font, (Component)title, colour, arg_0, arg_1)));
        ArrayList<Object> extras = new ArrayList<Object>();
        if (Screen.hasShiftDown()) {
            extras.addAll(test.visuals().description());
        }
        if (status.result() != Test.Result.PASSED && !status.message().isBlank()) {
            extras.add(Component.literal((String)("!!! " + status.message())).withStyle(ChatFormatting.RED));
        }
        int maxX = x;
        Objects.requireNonNull(font);
        y += 9 + 2;
        if (!extras.isEmpty()) {
            x += 6;
            Iterator charSequences = extras.stream().flatMap(it -> font.split((FormattedText)it, maxWidth).stream()).iterator();
            while (charSequences.hasNext()) {
                FormattedCharSequence extra = (FormattedCharSequence)charSequences.next();
                rendering.add(this.withXY(x, y, (x$, y$) -> stack.drawString(font, extra, x$, y$, 0xFFFFFF)));
                Objects.requireNonNull(font);
                y += 9;
                maxX = Math.max(maxX, x + font.width(extra));
            }
        }
        return new XY(maxX, y);
    }

    private Runnable withXY(int x, int y, IntBiConsumer consumer) {
        return () -> consumer.accept(x, y);
    }

    static MutableComponent statusColoured(Component input, Test.Status status) {
        return switch (status.result()) {
            default -> throw new MatchException(null, null);
            case Test.Result.PASSED -> input.copy().withStyle(ChatFormatting.GREEN);
            case Test.Result.FAILED -> input.copy().withStyle(ChatFormatting.RED);
            case Test.Result.NOT_PROCESSED -> input.copy();
        };
    }

    private static void renderTilledTexture(GuiGraphics pose, ResourceLocation texture, int x, int y, int width, int height, int borderWidth, int borderHeight, int textureWidth, int textureHeight, float alpha) {
        int sideWidth = Math.min(borderWidth, width / 2);
        int sideHeight = Math.min(borderHeight, height / 2);
        int leftWidth = sideWidth < borderWidth ? sideWidth + width % 2 : sideWidth;
        int topHeight = sideHeight < borderHeight ? sideHeight + height % 2 : sideHeight;
        int textureCentreWidth = textureWidth - borderWidth * 2;
        int textureCenterHeight = textureHeight - borderHeight * 2;
        int centreWidth = width - leftWidth - sideWidth;
        int centerHeight = height - topHeight - sideHeight;
        int leftEdgeEnd = x + leftWidth;
        int rightEdgeStart = leftEdgeEnd + centreWidth;
        int topEdgeEnd = y + topHeight;
        int bottomEdgeStart = topEdgeEnd + centerHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        ClientUtils.setupAlpha(alpha);
        ClientUtils.blitAlphaSimple(pose, x, y, 0.0f, 0.0f, leftWidth, topHeight, textureWidth, textureHeight);
        ClientUtils.blitAlphaSimple(pose, x, bottomEdgeStart, 0.0f, textureHeight - sideHeight, leftWidth, sideHeight, textureWidth, textureHeight);
        if (centreWidth > 0) {
            TestsOverlay.blitTiled(pose, leftEdgeEnd, y, centreWidth, topHeight, borderWidth, 0, textureCentreWidth, borderHeight, textureWidth, textureHeight, texture);
            if (centerHeight > 0) {
                TestsOverlay.blitTiled(pose, leftEdgeEnd, topEdgeEnd, centreWidth, centerHeight, borderWidth, borderHeight, textureCentreWidth, textureCenterHeight, textureWidth, textureHeight, texture);
            }
            TestsOverlay.blitTiled(pose, leftEdgeEnd, bottomEdgeStart, centreWidth, sideHeight, borderWidth, textureHeight - sideHeight, textureCentreWidth, borderHeight, textureWidth, textureHeight, texture);
        }
        if (centerHeight > 0) {
            TestsOverlay.blitTiled(pose, x, topEdgeEnd, leftWidth, centerHeight, 0, borderHeight, borderWidth, textureCenterHeight, textureWidth, textureHeight, texture);
            TestsOverlay.blitTiled(pose, rightEdgeStart, topEdgeEnd, sideWidth, centerHeight, textureWidth - sideWidth, borderHeight, borderWidth, textureCenterHeight, textureWidth, textureHeight, texture);
        }
        ClientUtils.blitAlphaSimple(pose, rightEdgeStart, y, textureWidth - sideWidth, 0.0f, sideWidth, topHeight, textureWidth, textureHeight);
        ClientUtils.blitAlphaSimple(pose, rightEdgeStart, bottomEdgeStart, textureWidth - sideWidth, textureHeight - sideHeight, sideWidth, sideHeight, textureWidth, textureHeight);
        ClientUtils.disableAlpha();
    }

    private static void blitTiled(GuiGraphics pose, int x, int y, int width, int height, int u, int v, int textureDrawWidth, int textureDrawHeight, int textureWidth, int textureHeight, ResourceLocation texture) {
        int xTiles = (int)Math.ceil((float)width / (float)textureDrawWidth);
        int yTiles = (int)Math.ceil((float)height / (float)textureDrawHeight);
        int drawWidth = width;
        int drawHeight = height;
        for (int tileX = 0; tileX < xTiles; ++tileX) {
            for (int tileY = 0; tileY < yTiles; ++tileY) {
                int renderWidth = Math.min(drawWidth, textureDrawWidth);
                int renderHeight = Math.min(drawHeight, textureDrawHeight);
                pose.blit(texture, x + textureDrawWidth * tileX, y + textureDrawHeight * tileY, (float)u, (float)v, renderWidth, renderHeight, textureWidth, textureHeight);
                drawHeight -= textureDrawHeight;
            }
            drawWidth -= textureDrawWidth;
            drawHeight = height;
        }
    }

    private static /* synthetic */ void lambda$renderTest$9(GuiGraphics stack, Font font, Component title, int colour, int x$, int y$) {
        stack.drawString(font, title, x$, y$, colour);
    }

    private static /* synthetic */ void lambda$render$0(GuiGraphics poseStack, Font font, Component title, int x$, int y$) {
        poseStack.drawString(font, title, x$, y$, 0xFFFFFF);
    }

    @FunctionalInterface
    public static interface IntBiConsumer {
        public void accept(int var1, int var2);
    }

    private record XY(int x, int y) {
    }
}

