/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.summary;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.testframework.summary.SummaryDumper;
import net.neoforged.testframework.summary.TestSummary;
import org.slf4j.Logger;

public interface FileSummaryDumper
extends SummaryDumper {
    public Path outputPath(ResourceLocation var1);

    public void write(TestSummary var1, Logger var2, PrintWriter var3) throws Exception;

    @Override
    default public void dump(TestSummary summary, Logger logger) {
        logger.info("Test summary processing...");
        Path outputPath = this.outputPath(summary.frameworkId());
        LamdbaExceptionUtils.uncheck(() -> {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(outputPath, new OpenOption[0]));){
                this.write(summary, logger, writer);
            }
        });
        logger.info("Wrote test summary to {}", (Object)outputPath);
    }
}

