/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.TestFunction;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.conf.Feature;
import net.neoforged.testframework.gametest.GameTestData;
import net.neoforged.testframework.impl.ReflectionUtils;
import net.neoforged.testframework.impl.TestFrameworkImpl;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class GameTestRegistration {
    public static final Method REGISTER_METHOD = (Method)LamdbaExceptionUtils.uncheck(() -> GameTestRegistration.class.getDeclaredMethod("register", new Class[0]));

    @GameTestGenerator
    public static List<TestFunction> register() {
        ArrayList<TestFunction> tests = new ArrayList<TestFunction>();
        for (final TestFrameworkImpl framework : TestFrameworkImpl.FRAMEWORKS) {
            if (!framework.configuration().isEnabled(Feature.GAMETEST)) continue;
            for (final Test test : framework.tests().all()) {
                GameTestData data = test.asGameTest();
                if (data == null) continue;
                String batchName = !test.groups().isEmpty() ? test.groups().get(0) : "ungrouped";
                tests.add(new TestFunction(data.batchName() == null ? batchName : data.batchName(), test.id(), data.structureName(), data.rotation(), data.maxTicks(), data.setupTicks(), data.required(), data.requiredSuccesses(), data.maxAttempts(), GameTestRegistration.rethrow(helper -> {
                    ReflectionUtils.addListener(helper, new GameTestListener(){

                        public void testStructureLoaded(GameTestInfo info) {
                        }

                        public void testPassed(GameTestInfo info) {
                            if (framework.tests().getStatus(test.id()).result() == Test.Result.NOT_PROCESSED) {
                                framework.changeStatus(test, Test.Status.passed("GameTest passed"), null);
                            }
                            this.disable();
                        }

                        public void testFailed(GameTestInfo info) {
                            framework.changeStatus(test, Test.Status.failed("GameTest fail: " + info.getError().getMessage()), null);
                            this.disable();
                        }

                        private void disable() {
                            framework.setEnabled(test, false, null);
                        }
                    });
                    framework.setEnabled(test, true, null);
                    framework.changeStatus(test, Test.Status.DEFAULT, null);
                    try {
                        data.function().accept((GameTestHelper)helper);
                    }
                    catch (GameTestAssertException assertion) {
                        framework.tests().setStatus(test.id(), Test.Status.failed("GameTest fail: " + assertion.getMessage()));
                        throw assertion;
                    }
                }, GameTestAssertException.class, ex -> framework.setEnabled(test, false, null))));
            }
        }
        return tests;
    }

    private static <T, E extends RuntimeException> Consumer<T> rethrow(Consumer<T> consumer, Class<E> exClass, Consumer<E> ex) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (RuntimeException e) {
                if (exClass.isInstance(e)) {
                    ex.accept((RuntimeException)exClass.cast(e));
                }
                throw e;
            }
        };
    }
}

