/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.testframework.conf.ClientConfiguration;
import net.neoforged.testframework.conf.Feature;
import net.neoforged.testframework.impl.DefaultMarkdownFileSummaryDumper;
import net.neoforged.testframework.impl.MutableTestFramework;
import net.neoforged.testframework.impl.TestFrameworkImpl;
import net.neoforged.testframework.summary.DefaultLogSummaryDumper;
import net.neoforged.testframework.summary.SummaryDumper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record FrameworkConfiguration(ResourceLocation id, Collection<Feature> enabledFeatures, int commandRequiredPermission, List<String> enabledTests, @Nullable Supplier<ClientConfiguration> clientConfiguration, List<SummaryDumper> dumpers) {
    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public boolean isEnabled(Feature feature) {
        return this.enabledFeatures.contains((Object)feature);
    }

    public MutableTestFramework create() {
        return new TestFrameworkImpl(this);
    }

    public static final class Builder {
        private final ResourceLocation id;
        private final Collection<Feature> features = EnumSet.noneOf(Feature.class);
        private int commandRequiredPermission = 2;
        private final List<String> enabledTests = new ArrayList<String>();
        private final List<SummaryDumper> dumpers = new ArrayList<SummaryDumper>();
        @Nullable
        private Supplier<ClientConfiguration> clientConfiguration;

        public Builder(ResourceLocation id) {
            this.id = id;
            for (Feature value : Feature.values()) {
                if (!value.isEnabledByDefault()) continue;
                this.enable(value);
            }
            this.dumpers(new DefaultLogSummaryDumper(), new DefaultMarkdownFileSummaryDumper());
        }

        public Builder enable(Feature ... features) {
            this.features.addAll(List.of(features));
            return this;
        }

        public Builder disable(Feature ... features) {
            this.features.removeAll(List.of(features));
            return this;
        }

        public Builder commandRequiredPermission(int commandRequiredPermission) {
            this.commandRequiredPermission = commandRequiredPermission;
            return this;
        }

        public Builder enableTests(String ... tests) {
            this.enabledTests.addAll(List.of(tests));
            return this;
        }

        public Builder clientConfiguration(Supplier<ClientConfiguration> clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder dumpers(SummaryDumper ... dumpers) {
            this.dumpers.addAll(List.of(dumpers));
            return this;
        }

        public Builder setDumpers(SummaryDumper ... dumpers) {
            this.dumpers.clear();
            return this.dumpers(dumpers);
        }

        public FrameworkConfiguration build() {
            return new FrameworkConfiguration(this.id, this.features, this.commandRequiredPermission, this.enabledTests, this.clientConfiguration, this.dumpers);
        }
    }
}

