/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl.test;

import com.google.common.base.Suppliers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.testframework.DynamicTest;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.TestFramework;
import net.neoforged.testframework.TestListener;
import net.neoforged.testframework.annotation.ForEachTest;
import net.neoforged.testframework.annotation.TestHolder;
import net.neoforged.testframework.annotation.WithListener;
import net.neoforged.testframework.gametest.EmptyTemplate;
import net.neoforged.testframework.gametest.ExtendedGameTestHelper;
import net.neoforged.testframework.gametest.GameTestData;
import net.neoforged.testframework.gametest.StructureTemplateBuilder;
import net.neoforged.testframework.impl.EventListenerGroupImpl;
import net.neoforged.testframework.impl.MutableTestFramework;
import net.neoforged.testframework.impl.ReflectionUtils;
import net.neoforged.testframework.impl.TestFrameworkImpl;
import net.neoforged.testframework.impl.reg.RegistrationHelperImpl;
import net.neoforged.testframework.registration.RegistrationHelper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractTest
implements Test {
    protected TestFramework framework;
    protected String id;
    protected final List<String> groups = new ArrayList<String>();
    protected boolean enabledByDefault;
    protected Test.Visuals visuals;
    @Nullable
    protected GameTestData gameTestData;
    protected final Set<TestListener> listeners = new HashSet<TestListener>();

    protected AbstractTest() {
        this.configureFrom(AnnotationHolder.clazz(this.getClass()));
    }

    protected final void configureFrom(AnnotationHolder holder) {
        WithListener withListener;
        TestHolder marker;
        ForEachTest parent = holder.parent().get(ForEachTest.class);
        if (parent == null) {
            parent = ForEachTest.DEFAULT;
        }
        if ((marker = holder.get(TestHolder.class)) != null) {
            this.id = parent.idPrefix() + (marker.value().equals("compute") ? holder.getName() : marker.value());
            this.enabledByDefault = marker.enabledByDefault();
            this.visuals = new Test.Visuals((Component)Component.literal((String)(marker.title().isBlank() ? TestFrameworkImpl.capitaliseWords(this.id(), "_") : marker.title())), Stream.of(marker.description()).map(Component::literal).collect(Collectors.toCollection(ArrayList::new)));
            this.groups.addAll(List.of(marker.groups()));
        }
        if ((withListener = holder.get(WithListener.class)) != null) {
            this.listeners.addAll(Stream.of(withListener.value()).map(TestListener::instantiate).toList());
        }
        if (parent.groups().length > 0) {
            this.groups.addAll(List.of(parent.groups()));
        }
        this.listeners.addAll(Stream.of(parent.listeners()).map(TestListener::instantiate).toList());
    }

    protected final void configureGameTest(@Nullable GameTest gameTest, @Nullable EmptyTemplate template) {
        if (gameTest == null) {
            return;
        }
        ResourceLocation templateFromPattern = null;
        if (template != null) {
            EmptyTemplate.Size size = EmptyTemplate.Size.parse(template.value());
            if (template.floor()) {
                templateFromPattern = new ResourceLocation(this.framework.id().getNamespace(), "empty_" + size + "_floor");
                if (!this.framework.dynamicStructures().contains(templateFromPattern)) {
                    this.framework.dynamicStructures().register(templateFromPattern, StructureTemplateBuilder.withSize(size.length(), size.height() + 1, size.width()).fill(0, 0, 0, size.length() - 1, 0, size.width() - 1, Blocks.IRON_BLOCK.defaultBlockState()).build());
                }
            } else {
                templateFromPattern = new ResourceLocation(this.framework.id().getNamespace(), "empty_" + size);
                if (!this.framework.dynamicStructures().contains(templateFromPattern)) {
                    this.framework.dynamicStructures().register(templateFromPattern, StructureTemplateBuilder.empty(size.length(), size.height(), size.width()));
                }
            }
        }
        this.gameTestData = new GameTestData(gameTest.batch().equals("defaultBatch") ? null : gameTest.batch(), gameTest.templateNamespace().isBlank() ? (templateFromPattern == null ? this.gameTestTemplate(gameTest) : templateFromPattern.toString()) : new ResourceLocation(gameTest.templateNamespace(), gameTest.template()).toString(), gameTest.required(), gameTest.attempts(), gameTest.requiredSuccesses(), this::onGameTest, gameTest.timeoutTicks(), gameTest.setupTicks(), StructureUtils.getRotationForRotationSteps((int)gameTest.rotationSteps()));
    }

    protected String gameTestTemplate(GameTest gameTest) {
        return gameTest.template();
    }

    @Override
    public void init(TestFramework framework) {
        this.framework = framework;
        try {
            Method onGameTestMethod = this.getClass().getDeclaredMethod("onGameTest", GameTestHelper.class);
            this.configureGameTest(onGameTestMethod.getAnnotation(GameTest.class), onGameTestMethod.getAnnotation(EmptyTemplate.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onDisabled() {
    }

    @Override
    public void onEnabled(Test.EventListenerGroup buses) {
    }

    protected void onGameTest(GameTestHelper helper) {
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean enabledByDefault() {
        return this.enabledByDefault;
    }

    @Override
    public Test.Visuals visuals() {
        return this.visuals;
    }

    @Override
    @Nullable
    public GameTestData asGameTest() {
        return this.gameTestData;
    }

    public Set<TestListener> listeners() {
        return this.listeners;
    }

    @Override
    public List<String> groups() {
        return this.groups;
    }

    public boolean isEnabled() {
        return this.framework.tests().isEnabled(this.id());
    }

    public void enable() {
        this.framework.setEnabled(this, true, null);
    }

    public Logger logger() {
        return this.framework.logger();
    }

    public Test.Status status() {
        return this.framework.tests().getStatus(this.id());
    }

    public void updateStatus(Test.Status status, @Nullable Entity changer) {
        this.framework.changeStatus(this, status, changer);
    }

    protected void fail(String message) {
        this.updateStatus(Test.Status.failed(message), null);
    }

    protected void pass() {
        this.updateStatus(Test.Status.passed(), null);
    }

    public final void requestConfirmation(Player player, Component message) {
        TestFramework testFramework = this.framework;
        if (testFramework instanceof MutableTestFramework) {
            MutableTestFramework internal = (MutableTestFramework)testFramework;
            player.sendSystemMessage((Component)message.copy().append(" ").append((Component)Component.literal((String)"Yes").withStyle(style -> style.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)).withClickEvent(internal.setStatusCommand(this.id(), Test.Result.PASSED, ""))).append(" ").append((Component)Component.literal((String)"No").withStyle(style -> style.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)).withClickEvent(internal.setStatusCommand(this.id(), Test.Result.FAILED, player.getGameProfile().getName() + " denied seeing the effects of the test"))))));
        }
    }

    protected static interface AnnotationHolder {
        @Nullable
        public <T extends Annotation> T get(Class<T> var1);

        public AnnotationHolder parent();

        public static AnnotationHolder clazz(final Class<?> clazz) {
            return new AnnotationHolder(){

                @Override
                @Nullable
                public <T extends Annotation> T get(Class<T> type) {
                    return clazz.getAnnotation(type);
                }

                @Override
                public AnnotationHolder parent() {
                    return AnnotationHolder.clazz(ReflectionUtils.parentOrTopLevel(clazz));
                }

                @Override
                public String getName() {
                    return clazz.getName();
                }
            };
        }

        public static AnnotationHolder method(final Method method) {
            return new AnnotationHolder(){

                @Override
                @Nullable
                public <T extends Annotation> T get(Class<T> type) {
                    return method.getAnnotation(type);
                }

                @Override
                public AnnotationHolder parent() {
                    return AnnotationHolder.clazz(method.getDeclaringClass());
                }

                @Override
                public String getName() {
                    return method.getName();
                }
            };
        }

        public String getName();
    }

    @ParametersAreNonnullByDefault
    public static abstract class Dynamic
    extends AbstractTest
    implements DynamicTest {
        private final List<DynamicTest.EnabledListener> enabledListeners = new ArrayList<DynamicTest.EnabledListener>();
        private final Supplier<Test.EventListenerGroup> eventListeners = Suppliers.memoize(() -> {
            EventListenerGroupImpl col = new EventListenerGroupImpl();
            this.whenEnabled(l -> ((EventListenerGroupImpl)l).copyFrom(col));
            return col;
        });
        private final List<Runnable> disabledListeners = new ArrayList<Runnable>();
        private final List<Consumer<ExtendedGameTestHelper>> onGameTest = new ArrayList<Consumer<ExtendedGameTestHelper>>();
        private boolean isDuringGameTest;

        @Override
        public TestFramework framework() {
            return this.framework;
        }

        @Override
        public void whenEnabled(DynamicTest.EnabledListener whenEnabled) {
            this.enabledListeners.add(whenEnabled);
        }

        @Override
        public Test.EventListenerGroup eventListeners() {
            return this.eventListeners.get();
        }

        @Override
        public void whenDisabled(Runnable whenDisabled) {
            this.disabledListeners.add(whenDisabled);
        }

        @Override
        public void onEnabled(Test.EventListenerGroup buses) {
            super.onEnabled(buses);
            this.enabledListeners.forEach(listener -> listener.onEnabled(buses));
        }

        @Override
        public void onDisabled() {
            super.onDisabled();
            this.disabledListeners.forEach(Runnable::run);
        }

        @Override
        public void onGameTest(Consumer<ExtendedGameTestHelper> consumer) {
            this.onGameTest.add(consumer);
        }

        @Override
        public RegistrationHelper registrationHelper(String modId) {
            RegistrationHelperImpl helper = new RegistrationHelperImpl(modId, this.framework.container());
            helper.register(this.framework.modEventBus());
            return helper;
        }

        @Override
        public RegistrationHelper registrationHelper() {
            return this.registrationHelper(this.createModId());
        }

        @Override
        public String createModId() {
            StringBuilder modId = new StringBuilder().append(this.framework().id().getNamespace()).append('_');
            boolean isInUpper = false;
            for (char c : this.id().toCharArray()) {
                if (Character.isUpperCase(c)) {
                    if (!isInUpper) {
                        isInUpper = true;
                        modId.append('_');
                    }
                    modId.append(Character.toLowerCase(c));
                    continue;
                }
                isInUpper = false;
                modId.append(c);
            }
            return modId.toString();
        }

        @Override
        protected String gameTestTemplate(GameTest gameTest) {
            return gameTest.template().isBlank() ? this.createModId() + ":gametest_template" : gameTest.template();
        }

        @Override
        protected void onGameTest(GameTestHelper helper) {
            this.isDuringGameTest = true;
            super.onGameTest(helper);
            ReflectionUtils.addListener(helper, new GameTestListener(){

                public void testStructureLoaded(GameTestInfo pTestInfo) {
                }

                public void testPassed(GameTestInfo pTestInfo) {
                    isDuringGameTest = false;
                }

                public void testFailed(GameTestInfo pTestInfo) {
                    isDuringGameTest = false;
                }
            });
            ExtendedGameTestHelper actualHelper = new ExtendedGameTestHelper(helper.testInfo);
            this.onGameTest.forEach(test -> test.accept(actualHelper));
        }

        @Override
        public boolean isDuringGameTest() {
            return this.isDuringGameTest;
        }

        @Override
        public void fail(String message) {
            DynamicTest.super.fail(message);
        }

        @Override
        public void pass() {
            DynamicTest.super.pass();
        }
    }
}

