/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl.packet;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.conf.Feature;
import net.neoforged.testframework.impl.MutableTestFramework;

public record ChangeEnabledPayload(MutableTestFramework framework, String testId, boolean enabled) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("neoforge", "tf_change_enabled");

    public void handle(PlayPayloadContext context) {
        switch (context.flow().getReceptionSide()) {
            case CLIENT: {
                Consumer<String> enablerer = this.enabled ? id -> this.framework.tests().enable((String)id) : id -> this.framework.tests().disable((String)id);
                enablerer.accept(this.testId);
                break;
            }
            case SERVER: {
                Player player = (Player)context.player().orElseThrow();
                if (!this.framework.configuration().isEnabled(Feature.CLIENT_MODIFICATIONS) || !Objects.requireNonNull(player.getServer()).getPlayerList().isOp(player.getGameProfile())) break;
                this.framework.tests().byId(this.testId).ifPresent(test -> this.framework.setEnabled((Test)test, this.enabled, (Entity)player));
            }
        }
    }

    public static ChangeEnabledPayload decode(MutableTestFramework framework, FriendlyByteBuf buf) {
        return new ChangeEnabledPayload(framework, buf.readUtf(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.testId);
        buf.writeBoolean(this.enabled);
    }

    public ResourceLocation id() {
        return ID;
    }
}

