/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import net.neoforged.testframework.impl.MutableTestFramework;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Builder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record LoggerSetup(MutableTestFramework framework) {
    public void prepareLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = LoggerSetup.getLoggerConfiguration(config, this.framework.logger().getName());
        loggerConfig.setParent(null);
        loggerConfig.getAppenders().keySet().forEach(arg_0 -> ((LoggerConfig)loggerConfig).removeAppender(arg_0));
        loggerConfig.addAppender(this.fileAppender(), Level.DEBUG, null);
        loggerConfig.addAppender(this.consoleAppender(), Level.INFO, null);
    }

    private Appender fileAppender() {
        return LoggerSetup.started(((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName("TestFramework " + this.framework.id() + " file log")).withFileName("logs/tests/" + this.framework.id().toString().replace(":", "_") + "/log.log").withFilePattern("logs/%d{yyyy-MM-dd}-%i.log.gz").setLayout((Layout)PatternLayout.newBuilder().withPattern("[%d{ddMMMyyyy HH:mm:ss}] [%logger]: %minecraftFormatting{%msg}{strip}%n%xEx").build())).withPolicy((TriggeringPolicy)OnStartupTriggeringPolicy.createPolicy((long)1L)));
    }

    private Appender consoleAppender() {
        return LoggerSetup.started((Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("TestFramework " + this.framework.id() + " console log")).setLayout((Layout)PatternLayout.newBuilder().withPattern("%highlightForge{Tests:}{FATAL=magenta, ERROR=magenta, WARN=magenta, INFO=magenta, DEBUG=magenta, TRACE=magenta} %highlightForge{[%d{ddMMMyyyy HH:mm:ss}] [%logger]: %minecraftFormatting{%msg}{strip}%n%xEx}").build())).setIgnoreExceptions(false));
    }

    private static <A extends Appender> A started(Builder<? extends A> builder) {
        Appender app = (Appender)builder.build();
        app.start();
        return (A)app;
    }

    private static LoggerConfig getLoggerConfiguration(Configuration configuration, String loggerName) {
        LoggerConfig lc = configuration.getLoggerConfig(loggerName);
        if (lc.getName().equals(loggerName)) {
            return lc;
        }
        LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), lc.isAdditive());
        nlc.setParent(lc);
        configuration.addLogger(loggerName, nlc);
        configuration.getLoggerContext().updateLoggers();
        return nlc;
    }
}

